/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown when the method being called has not been implemented by the context provider.
 */
public class NotImplementedException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5753455471403067790L;

	/**
	 * @see IdASException#IdASException()
	 */
	public NotImplementedException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public NotImplementedException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public NotImplementedException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(Throwable)
	 */
	public NotImplementedException(Throwable cause) {
		super(cause);
	}

}
