/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

import java.net.URI;

/**
 * Represents an extended argument. Some methods within the IdAS api
 * support the ability to pass extra information when calling them.
 * Typically this is done by passing an array of IExtension objects.
 *
 * Standard extensions defined by the Higgins project are listed at <TODO> 
 */
public interface IExtension {
	
	/**
	 * Returns the extension identifier for this extension.
	 * All extensions have an identifier.  Preferably one which
	 * is resolvable to documentation concerning the extension
	 *  
	 * @return URI which identifies this extension
	 */
	public URI getID();
	
	/**
	 * Returns true if this extension should cause the operation to fail
	 * when the context provider does not support it.
	 * When true, the context provider will throw {@link UnhandledExtensionException}
	 * if it does not support the extension.
	 * When false, the context provider silently ignores the extension when it 
	 * does not support it for the operation.  
	 * When false and the context provider supports the extension for the operation, 
	 * it makes use of the extension.
	 * @return boolean indicating if the extension is unsupported by the context that 
	 * the operation should fail.
	 */
	public boolean failIfUnsupported();
	
}
