/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;

/**
 * As defined at <a href="http://spwiki.editme.com/ContextProvider#ContextFactory"/>http://spwiki.editme.com/ContextProvider#ContextFactory</a>, This interface is implemented by IdAS context providers so that their {@link IContext} instances may be instantiated.<p> 
 * TODO (Arch)(Doc): Talk about what's required to make this work -- how factories are registered and referenced in the Higgins system.<p>
 * TODO (Doc): Finish commenting methods. 
 */
public interface IContextFactory extends IConfigurableComponent
{
	public String getName() throws IdASException;

	/**
	 * Returns the context types supported by this context factory. 
	 * @return List of context types. 
	 * @throws IdASException
	 */
	public List getTypes() throws IdASException;
	
	/**
	 *
	 * @param filter Format TBD
	 * @return An Iterator of {@link URI}s. The set of Context References of Contexts which have been created by this Context Factory  
	 * @throws IdASException
	 */
	public Iterator getContexts(String filter) throws IdASException;
	
	/**
	 * Using a context ID, creates an instance of {@link IContext} and returns it.
	 * @param contextID context ID specifying the Context to create.
	 * @return An IContext instance appropriate for the context ID.
	 * @throws IdASException
	 */
	public IContext createContext(IContextId contextID) throws IdASException;

	/**
	 * Returns the policy in effect for this Context Factory.
	 * @return Format is WS-Policy / WS-SecurityPolicy<p>
	 * @throws IdASException
	 * TODO (Arch)(Doc): Describe format in more detail. Give examples.
	 */
	public String getPolicy() throws IdASException;

	/**
	 * Sets the policy for for this Context Factory.
	 * @param policy Format is WS-Policy / WS-SecurityPolicy<p>
	 * @throws IdASException
	 * TODO (Arch)(Doc): Describe format in more detail. Give examples.
	 */
	public void	setPolicy(String policy) throws IdASException;
	
	/**
	 * Returns the setting descriptor for a given context Id. A typical use case would be
	 * an IdAS application getting a handle to the context factory based on the type of 
	 * context to create and then using this API to get the setting descriptors for a 
	 * context id to be created based on this factory.  
	 * @param contextIdName
	 * @return The setting descriptor for a context id based on this context factory
	 * @throws IdASException
	 */
	public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException;
	
}
