/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.common;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;

public class AuthNSelfIssuedMaterials
implements IAuthNAttributesMaterials {
    private IAuthNAttributesMaterials _impl;
    private ISimpleAttrValue _ppidAttr;
    private ISimpleAttrValue _modAttr;
    private ISimpleAttrValue _expAttr;
    private IAttribute _managedAttr;
    public static final URI MANAGED_ATTR_URI = URI.create("http://www.eclipse.org/higgins/ontologies/2006/higgins#cardKeyHash");
    public static final URI MANAGED_ATTR_TYPE_URI = URI.create("http://www.eclipse.org/higgins/ontologies/2006/higgins#cardKeyHashType");
    public static final URI ATTR_TYPE_PPID = URI.create("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");
    public static final URI ATTR_TYPE_PUBLIC_KEY_MODULUS = URI.create("http://www.eclipse.org/higgins/ontologies/2006/higgins#publicKeyModulus");
    public static final URI ATTR_TYPE_PUBLIC_KEY_EXPONENT = URI.create("http://www.eclipse.org/higgins/ontologies/2006/higgins#publicKeyExponent");

    public AuthNSelfIssuedMaterials(IContext context, byte[] ppid, byte[] publicKeyMod, byte[] publicKeyExp) throws IdASException {
        this._impl = context.buildAuthNAttributesMaterials();
        this._managedAttr = this.addAttribute(MANAGED_ATTR_URI);
        IComplexAttrValue val = this._managedAttr.addComplexValue(MANAGED_ATTR_TYPE_URI);
        IAttribute attrTemp = val.addAttribute(ATTR_TYPE_PPID);
        this._ppidAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ppid);
        attrTemp = val.addAttribute(ATTR_TYPE_PUBLIC_KEY_MODULUS);
        this._modAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)publicKeyMod);
        attrTemp = val.addAttribute(ATTR_TYPE_PUBLIC_KEY_EXPONENT);
        this._expAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)publicKeyExp);
    }

    public AuthNSelfIssuedMaterials(IContext context, String b64PPID, String b64PublicKeyMod, String b64PublicKeyExp) throws IdASException {
        this._impl = context.buildAuthNAttributesMaterials();
        this._managedAttr = this.addAttribute(MANAGED_ATTR_URI);
        IComplexAttrValue val = this._managedAttr.addComplexValue(MANAGED_ATTR_TYPE_URI);
        IAttribute attrTemp = val.addAttribute(ATTR_TYPE_PPID);
        this._ppidAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)b64PPID);
        attrTemp = val.addAttribute(ATTR_TYPE_PUBLIC_KEY_MODULUS);
        this._modAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)b64PublicKeyMod);
        attrTemp = val.addAttribute(ATTR_TYPE_PUBLIC_KEY_EXPONENT);
        this._expAttr = attrTemp.addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)b64PublicKeyExp);
    }

    public byte[] getPPIDBytes() throws IdASException {
        return ((ByteBuffer)this._ppidAttr.getData()).array();
    }

    public byte[] getPublicKeyModBytes() throws IdASException {
        return ((ByteBuffer)this._modAttr.getData()).array();
    }

    public byte[] getPublicKeyExpBytes() throws IdASException {
        return ((ByteBuffer)this._expAttr.getData()).array();
    }

    public String getPPIDString() throws IdASException {
        return this._ppidAttr.getLexical();
    }

    public String getPublicKeyModString() throws IdASException {
        return this._modAttr.getLexical();
    }

    public String getPublicKeyExpString() throws IdASException {
        return this._expAttr.getLexical();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return this._impl.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this._impl.addAttribute(copyFrom);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this._impl.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this._impl.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this._impl.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this._impl.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this._impl.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this._impl.removeAttributeValue(attr);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this._impl.equals(attributes);
    }

    public IAttribute getManagedAttr() {
        return this._managedAttr;
    }

    public URI getManagedAttrURI() {
        return MANAGED_ATTR_URI;
    }
}

