/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.common;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Marker class for specifying a Context Provider-configured least privileged user identity for {@link org.eclipse.higgins.idas.api.IContext#open(Object)}.   
 * When this is used, the Context Provider may use a configured least priviledged user to open the context.   
 * An application consuming IdAS may require specific rights to the underlying store to accomplish the tasks it has been designed to accomplish.  
 * Typically, the configurer of the Context Provider in the system has the knowledge and ability to define an identity as which the IdAS consumer 
 * may perform its required tasks successfully.  
 * 
 */
public class AuthNLeastPrivilegedUserMaterials {

	/**
	 * @throws IdASException 
	 * 
	 */
	public AuthNLeastPrivilegedUserMaterials() throws IdASException {
	}
}
