package org.eclipse.higgins.idas.common;

import java.net.URI;

import org.eclipse.higgins.idas.api.IExtension;

public class DereferenceAttrValuesExtension implements IExtension {
	public static final String id = "http://www.eclipse.org/higgins/idas/extension/derefattrvals";
	
	private URI[] attrs = null;
	private URI[] types = null;
	
	/**
	 * 
	 * @param attrs may be null. When null, any attribute that is dereferencable should be dereferenced.  
	 * When not null, specifies only those attributes which should be dereferenced 
	 * @param types may be null.  When null, any value type that is dereferencable should be dereferenced.  
	 * When not null, specifies only those value types which should be dereferenced 
	 */
	public DereferenceAttrValuesExtension(URI[] attrIDs, URI[] types) {
		this.attrs = attrIDs;
		this.types = types;
	}
	
	public URI getID() {
		return URI.create(id);
	}

	/**
	 * 
	 * @return true if the passed attribute ID should be dereferenced.
	 */
	public boolean shouldDereference(URI attrID, URI valType) {
		boolean derefAttr = false;
		boolean derefVal = false;
		if (attrs != null) {
			for (int loop = 0; loop < attrs.length; loop++) {
				if (attrs[loop].compareTo(attrID) == 0) {
					// This attrID should be dereferenced
					derefAttr = true;
					break;
				}
			}
		} else {
			derefAttr = true;
		}
		if (types != null) {
			for (int loop = 0; loop < types.length; loop++) {
				if (types[loop].compareTo(valType) == 0) {
					// This val type should be dereferenced
					derefVal = true;
					break;
				}
			}
		} else {
			derefVal = true;
		}
		return derefAttr & derefVal;
	}
	
}
