/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/
package org.eclipse.higgins.idas.common;

import java.net.URI;

import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IContext;

/**
 * When this extension is present, it specifies that 
 * {@link IContext#open(Object, IExtension[])} requires the context provider
 * to force a re-authentication of the passed authN materials. 
 * Operations that this extension is valid for include: {@link IContext#open(Object, IExtension[])}
 */
public class ForceReauthenticationExtension implements IExtension {
	private static final String id = "http://www.eclipse.org/higgins/idas/extension/forcereauthentication";
	private boolean failUnsupported;

	/**
	 * By default, we'll have {@link #failIfUnsupported()} returns true. 
	 * It doesn't make much sense for a caller to want this extension to silently fail.
	 */
	public ForceReauthenticationExtension() {
		this.failUnsupported = true;
	}
	
	public ForceReauthenticationExtension(boolean failIfUnsupported) {
		this.failUnsupported = failIfUnsupported;
	}

	public URI getID() {
		return URI.create(id);
	}

	public boolean failIfUnsupported() {
		return failUnsupported;
	}

}
