/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.common;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.MultipleValuesExistException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;

public class AuthNNamePasswordMaterials
implements IAuthNAttributesMaterials {
    private IAuthNAttributesMaterials _impl;
    private IAttribute _managedAttr;
    public static final URI ATTR_TYPE_USERNAME = URI.create("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#userName");
    public static final URI ATTR_MANAGED_URI = URI.create("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#password");

    public AuthNNamePasswordMaterials(IContext context, String username, String password) throws IdASException {
        this._impl = context.buildAuthNAttributesMaterials();
        IAttribute attr = this.addAttribute(ATTR_TYPE_USERNAME);
        attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)username);
        if (password != null) {
            this._managedAttr = this.addAttribute(ATTR_MANAGED_URI);
            this._managedAttr.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)password);
        }
    }

    public String getUsername() throws IdASException {
        IAttribute attr = this.getAttribute(ATTR_TYPE_USERNAME);
        Iterator iter = attr.getValues();
        String ret = null;
        if (iter.hasNext()) {
            IAttributeValue val = (IAttributeValue)iter.next();
            if (!val.isSimple()) {
                throw new IdASException("Simple value expected, got complex value: " + val.toString());
            }
            ret = ((ISimpleAttrValue)val).getLexical();
            if (iter.hasNext()) {
                throw new MultipleValuesExistException("Single value expected, got multiple");
            }
        }
        if (ret == null) {
            throw new IdASException("No " + ATTR_TYPE_USERNAME + " Attribute present");
        }
        return ret;
    }

    public String getPassword() throws IdASException {
        IAttribute attr = this.getAttribute(ATTR_MANAGED_URI);
        Iterator iter = attr.getValues();
        String ret = null;
        if (iter.hasNext()) {
            IAttributeValue val = (IAttributeValue)iter.next();
            if (!val.isSimple()) {
                throw new IdASException("Simple value expected, got complex value: " + val.toString());
            }
            ret = ((ISimpleAttrValue)val).getLexical();
            if (iter.hasNext()) {
                throw new MultipleValuesExistException("Single value expected, got multiple");
            }
        }
        if (ret == null) {
            throw new IdASException("No " + ATTR_MANAGED_URI + " attribute present");
        }
        return ret;
    }

    public String toString() {
        try {
            return this.getUsername();
        }
        catch (IdASException e) {
            return null;
        }
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return this._impl.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this._impl.addAttribute(copyFrom);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this._impl.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this._impl.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this._impl.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this._impl.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this._impl.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this._impl.removeAttributeValue(attr);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this._impl.equals(attributes);
    }

    public IAttribute getManagedAttr() {
        return this._managedAttr;
    }

    public URI getManagedAttrID() {
        return ATTR_MANAGED_URI;
    }
}

