/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.inmem;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bandit.util.misc.CIStringKey;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.inmem.InMemoryEntity;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.IEntityContainer;

public class InMemoryContext
extends BasicContext
implements IEntityContainer {
    private Log log;
    private boolean _bIsOpen;
    private HashMap _idHashMap;
    static /* synthetic */ Class class$0;

    public InMemoryContext(IContextId contextID) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.inmem.InMemoryContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((String)clazz.getName());
        this._bIsOpen = false;
    }

    public String open(Object unknown) throws IdASException {
        if (this._bIsOpen) {
            throw new ContextOpenException();
        }
        this._bIsOpen = true;
        return null;
    }

    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        if (this._idHashMap != null) {
            this._idHashMap.clear();
        }
        this._idHashMap = null;
        this._bIsOpen = false;
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    public String getSchema() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public String exportData(String arg0, String arg1) throws IdASException {
        throw new NotImplementedException();
    }

    public void importData(String arg0, String arg1) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntity getEntity(String entityID) throws IdASException {
        return this.getEntity(entityID, null);
    }

    public IEntity getEntity(String entityID, Iterator attrSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        CIStringKey idKey = new CIStringKey(entityID);
        if (this._idHashMap == null) {
            throw new NoSuchEntityException("No such entity: " + idKey);
        }
        IEntity ds = (IEntity)this._idHashMap.get(idKey);
        if (ds == null) {
            throw new NoSuchEntityException("No such entity: " + idKey);
        }
        return ds;
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    private void _addEntity(String entityID, IEntity ds) {
        CIStringKey idKey = new CIStringKey(entityID);
        if (this._idHashMap == null) {
            this._idHashMap = new HashMap();
        }
        this._idHashMap.put(idKey, ds);
    }

    public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        InMemoryEntity ds = new InMemoryEntity(this, type, entityID);
        this._addEntity(entityID, ds);
        return ds;
    }

    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public void applyUpdates() throws IdASException {
    }

    public boolean verifyEntityAttributes(String arg0, Iterator arg1) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public void updateNotification(EntityNotification entityNotif) throws IdASException {
        if (entityNotif.getAction().equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE")) {
            CIStringKey idKey = new CIStringKey(entityNotif.getEntity().getEntityID());
            if (this._idHashMap != null) {
                this._idHashMap.remove(idKey);
            }
        }
    }
}

