/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.inmem;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bandit.util.misc.CIStringKey;
import org.eclipse.higgins.audit.api.AuditException;
import org.eclipse.higgins.audit.api.AuditRecord;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.inmem.InMemoryEntity;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.IEntityContainer;

public class InMemoryContext
extends BasicContext
implements IEntityContainer {
    private Log log;
    private Log _auditLog;
    private AuditRecord _auditRecord;
    private boolean _bIsOpen;
    private HashMap _idHashMap;
    private IContextId _contextID;
    private String _contextURIs;
    private String _contextTypes;
    private Map _contextSettings;
    static /* synthetic */ Class class$0;

    public InMemoryContext(IContextId contextID) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.inmem.InMemoryContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((String)clazz.getName());
        this._auditLog = LogFactory.getLog((String)"higgins.audit.events");
        this._auditRecord = null;
        this._contextURIs = "";
        this._contextTypes = "";
        this._bIsOpen = false;
        this._contextID = contextID;
        this._contextSettings = contextID.getConfiguration();
        URI[] contextURIs = this._contextID.getUris();
        int iLoop = 0;
        while (iLoop < contextURIs.length) {
            this._contextURIs = String.valueOf(this._contextURIs) + contextURIs[iLoop].toString() + ", ";
            ++iLoop;
        }
        String[] contextTypes = this._contextID.getTypes();
        iLoop = 0;
        while (iLoop < contextTypes.length) {
            this._contextTypes = String.valueOf(this._contextTypes) + contextTypes[iLoop] + ", ";
            ++iLoop;
        }
        String strAuditRecordClass = (String)this._contextSettings.get("AuditRecordClass");
        if (strAuditRecordClass != null) {
            try {
                this._auditRecord = (AuditRecord)ConfigurableComponentFactoryHelper.getInstanceFromClassName((String)strAuditRecordClass);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    public String open(Object unknown) throws IdASException {
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        this.setOpen(true);
        this._emitAuditRecord(0x1000007, 0, null, null, null);
        return null;
    }

    public void close() throws IdASException {
        if (this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        super.close();
        if (this._idHashMap != null) {
            this._idHashMap.clear();
        }
        this._idHashMap = null;
        this._emitAuditRecord(0x1000008, 0, null, null, null);
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    public String getSchema() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public void importData(String arg0, String arg1) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntity getEntity(String entityID) throws IdASException {
        return this.getEntity(entityID, null);
    }

    public IEntity getEntity(String entityID, Iterator attrSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        CIStringKey idKey = new CIStringKey(entityID);
        if (this._idHashMap == null) {
            throw new NoSuchEntityException("No such entity: " + idKey);
        }
        IEntity ds = (IEntity)this._idHashMap.get(idKey);
        if (ds == null) {
            throw new NoSuchEntityException("No such entity: " + idKey);
        }
        this._emitAuditRecord(0x1000005, 0, null, entityID, null);
        return ds;
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        this._emitAuditRecord(0x1000005, 0, null, filter == null ? null : filter.toString(), null);
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    private void _addEntity(String entityID, IEntity ds) {
        CIStringKey idKey = new CIStringKey(entityID);
        if (this._idHashMap == null) {
            this._idHashMap = new HashMap();
        }
        this._idHashMap.put(idKey, ds);
    }

    public IEntity addEntity(URI type, String entityID) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        InMemoryEntity ds = new InMemoryEntity(this, type, entityID);
        this._addEntity(entityID, ds);
        return ds;
    }

    public void applyUpdates() throws IdASException {
    }

    public boolean verifyEntityAttributes(String arg0, Iterator arg1) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException();
        }
        throw new NotImplementedException();
    }

    public void updateNotification(EntityNotification entityNotif) throws IdASException {
        if (entityNotif.getAction().equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE")) {
            CIStringKey idKey = new CIStringKey(entityNotif.getEntity().getEntityID());
            if (this._idHashMap != null) {
                this._idHashMap.remove(idKey);
            }
        }
    }

    private void _emitAuditRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._auditRecord != null) {
            try {
                this._auditRecord.clearRecord();
                this._auditRecord.setOriginatorInfo("Higgins IdAS JNDI Context Provider", null, null, null, null, null);
                if (sTargetInfo == null) {
                    sTargetInfo = "";
                }
                if (sEventInfo == null) {
                    sEventInfo = "";
                }
                this._auditRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                this._auditRecord.setTargetInfo(null, this._contextURIs, this._contextTypes, null, null, sTargetInfo);
                this._auditLog.info((Object)this._auditRecord);
            }
            catch (AuditException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }
}

