/**
 * Copyright (c) 2006-2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 *		Jim Sermersheim
 *		Duane Buss
 */

package org.eclipse.higgins.idas.cp.inmem;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;


/**
* An implementation of a 
* <a href="http://www.eclipse.org/higgins/">Higgins</a>.
*  Context Factory for the InMemory/Mapping Context Provider
*  which is intended for use when Entities 
*  are being manufactored on the fly or need to be cached privatly.  
*  
* Please see the Samples section for one usage of creating Entities 
* from SAML assertions, then allowing interfaces which require 
* Entities to manipulate the InMemory Entity.

* @author jimse@novell.com
* @author tdoman@novell.com
* @author dbuss@novell.com
*/

public class InMemoryContextFactory extends BasicAttributeSet implements IContextFactory, IConfigurableComponent
{
//	private Map _mapGlobalSettings;
//	private Map _mapComponentSettings;

	public InMemoryContextFactory() throws IdASException
	{
		super();
	}

	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getName()
	 */
	public String getName() throws IdASException
	{
		return "Higgins InMemory Context Provider";
	}

	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getContexts(java.lang.String)
	 */
	public Iterator  getContexts(
	    String arg0) throws IdASException
	{
		throw new NotImplementedException();
	}


	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContextFactory#getPolicy()
	 */
	public String getPolicy() throws IdASException
	{
		throw new NotImplementedException();
	}

	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.higgins.idas.api.IContextFactory#setPolicy(java.lang.String)
	 */
	public void setPolicy(
		String arg0) throws IdASException
	{
		throw new NotImplementedException();
	}

	/**
	 * 
	 */
	public void configure(
		Map mapGlobalSettings,
		String strComponentName,
		Map mapComponentSettings) throws Exception
	{
//		_mapGlobalSettings = mapGlobalSettings;
//		_mapComponentSettings = mapComponentSettings;
	}

	public IContext createContext(IContextId contextID) throws IdASException {
		return new InMemoryContext(contextID);	
	}
}
