/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.IFactoryConfiguration;
import org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration;
import org.eclipse.higgins.idas.cp.jena2.util.ConfigUtil;

public abstract class AbstractContextFactory
implements IContextFactory {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory = AbstractContextFactory.class$("org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory")) : class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory));
    protected String id = null;
    protected String name = null;
    protected String policy = null;
    protected File configFile = null;
    protected IFactoryConfiguration config = null;
    protected String cacheLocation = null;
    protected OntDocumentManager documentManager = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$AbstractContextFactory;

    protected AbstractContextFactory(String id, String name) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::AbstractContextFactory");
        this.setID(id);
        this.setName(name);
    }

    public String getID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getID");
        return this.id;
    }

    protected void setID(String id) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setID");
        this.id = id;
    }

    public String getName() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getName");
        if (this.config != null) {
            return this.name;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    protected void setName(String name) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setName");
        this.name = name;
    }

    public void initialize(File configFile) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::initialize");
        System.out.println(this.getClass().getName() + " Loading configuration from: \"" + configFile + "\"");
        this.configFile = configFile;
        this.config = new FactoryConfiguration(this.getID());
        this.config.load(configFile);
        this.cacheLocation = this.config.getCachePath();
        this.documentManager = OntDocumentManager.getInstance();
        this.documentManager.clearCache();
        this.documentManager.addAltEntry("http://www.eclipse.org/higgins/ontologies/2006/higgins", ConfigUtil.getCacheFileName("http://www.eclipse.org/higgins/ontologies/2006/higgins", this.cacheLocation));
        this.documentManager.addAltEntry("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl", ConfigUtil.getCacheFileName("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl", this.cacheLocation));
        this.documentManager.addAltEntry("http://www.eclipse.org/higgins/ontologies/2006/display-data", ConfigUtil.getCacheFileName("http://www.eclipse.org/higgins/ontologies/2006/display-data", this.cacheLocation));
    }

    public void destroyContext(URI contextRef) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::destroyContext");
        if (this.config != null) {
            if (this.config.getContextConfig(contextRef) != null) {
                this.config.removeContextConfig(contextRef);
            }
        } else {
            throw new IdASException("Factory hasn't been initialized yet.");
        }
    }

    public List getConfigPropNames() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getConfigPropNames");
        if (this.config != null) {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<?> e = this.config.getDefaultProperties().propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                list.add(s);
            }
            return list;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public Properties getDefaultConfig() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getDefaultConfig");
        if (this.config != null) {
            return this.config.getDefaultProperties();
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public boolean canCreate(URI contextRef, Properties configData) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::canCreate(URI, Properties)");
        if (this.config != null) {
            if (this.config.getContextConfig(contextRef) != null) {
                throw new IdASException("Context " + contextRef + " is already configured with different configuration data.");
            }
            return this.isValidProperties(configData);
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public boolean canCreate(URI contextRef) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::canCreate(URI)");
        if (this.config != null) {
            return this.config.getContextConfig(contextRef) != null;
        }
        throw new IdASException("Factory hasn't been initialized yet.");
    }

    public IContext createContext(URI contextRef, Properties configData) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::createContext(URI, Properties)");
        IContext ctx = null;
        if (this.config != null) {
            IContextConfiguration cfg = this.config.getContextConfig(contextRef);
            if (cfg != null) {
                throw new IdASException("Context " + contextRef + " is already configured with different configuration data.");
            }
            if (!this.isValidProperties(configData)) {
                throw new IdASException("Context " + contextRef + " couldn't be created - invalid configuration data.");
            }
            cfg = this.config.createContextConfig(contextRef, configData);
            ctx = this.createContext(cfg);
            if (ctx != null) {
                this.config.setContextConfig(cfg);
                this.config.save(this.configFile);
            }
        } else {
            throw new IdASException("Factory hasn't been initialized yet.");
        }
        return ctx;
    }

    public IContext createContext(URI contextRef) throws IdASException {
        IContextConfiguration cfg;
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::createContext(URI)");
        IContext ctx = null;
        if (this.config != null) {
            cfg = this.config.getContextConfig(contextRef);
            if (cfg == null) {
                // empty if block
            }
            if (cfg == null) {
                throw new IdASException("Context " + contextRef + "couldn't be created - can't find configuration data.");
            }
        } else {
            throw new IdASException("Factory hasn't been initialized properly.");
        }
        ctx = this.createContext(cfg);
        return ctx;
    }

    public Iterator getContexts(String filter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getContexts");
        if (this.config != null) {
            return this.config.getContextRefs().iterator();
        }
        throw new IdASException("Factory hasn't been initialized properly.");
    }

    public String getPolicy() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::getPolicy");
        return this.policy;
    }

    public void setPolicy(String policy) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::setPolicy");
        this.policy = policy;
    }

    protected boolean isValidProperties(Properties props) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.AbstractContextFactory::isValidProperties");
        boolean res = false;
        if (this.config != null) {
            res = true;
            Properties defaults = this.config.getDefaultProperties();
            Iterator<Object> itr = props.keySet().iterator();
            while (itr.hasNext()) {
                if (defaults.containsKey(itr.next())) continue;
                res = false;
                break;
            }
        }
        return res;
    }

    protected abstract IContext createContext(IContextConfiguration var1) throws IdASException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

