/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.cp.jena2.impl.ComplexValue;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject;
import org.eclipse.higgins.idas.cp.jena2.impl.Metadata;
import org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;

public class Attribute
implements IAttribute {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute = Attribute.class$("org.eclipse.higgins.idas.cp.jena2.impl.Attribute")) : class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute));
    protected OntProperty property_ = null;
    protected Context context_ = null;
    protected IAttributeModel attModel_ = null;
    protected OntClass ownerClass_ = null;
    protected OntClass valueClass_ = null;
    protected boolean isSimple_ = false;
    protected DigitalSubject subject_ = null;
    protected Individual owner_ = null;
    protected OntClass metadataHolderClass_ = null;
    protected Individual metadataHolder_ = null;
    protected URI type_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$Attribute;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    protected Attribute(Context context, DigitalSubject subject, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::Attribute(..., DigitalSubject, ...)");
        if (subject == null) {
            throw new IdASException("Parameter \"subject\" is null.");
        }
        this.subject_ = subject;
        this.init(context, subject.getSubjectIndividual(), property, model);
    }

    protected Attribute(Context context, ComplexValue valueOwner, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::Attribute(..., ComplexValue, ...)");
        if (valueOwner == null) {
            throw new IdASException("Parameter \"valueOwner\" is null.");
        }
        this.subject_ = valueOwner.getSubjectOwner();
        this.init(context, valueOwner.getValueIndividual(), property, model);
    }

    private void init(Context context, Individual owner, OntProperty property, IAttributeModel model) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::init");
        if (context == null) {
            throw new IdASException("Parameter \"context\" is null.");
        }
        if (owner == null) {
            throw new IdASException("Parameter \"owner\" is null.");
        }
        if (property == null) {
            throw new IdASException("Parameter \"property\" is null.");
        }
        this.context_ = context;
        this.owner_ = owner;
        this.property_ = property;
        this.ownerClass_ = this.context_.getOntClass(this.owner_.getRDFType().getURI());
        this.metadataHolderClass_ = ModelUtils.getAttributeMetadataHolderClass(context, property);
        this.attModel_ = model;
        this.checkAttribute();
        this.initValueClass();
    }

    private void checkAttribute() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::checkAttribute");
        String uri = this.property_.getURI();
        OntProperty prop = this.context_.getOntProperty(uri);
        OntProperty attrProp = this.context_.getOntProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        if (prop == null) {
            throw new IdASException("Can not find property with URI " + uri);
        }
        if (attrProp == null) {
            throw new IdASException("Can not find property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        }
        if (!ModelUtils.isPropertyRelative(attrProp, prop)) {
            throw new IdASException("Property with URI " + uri + " is not a subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.ownerClass_, prop)) {
            throw new IdASException("Can not create attribute with type " + uri + " for DigitalSubject with class " + this.ownerClass_.getURI());
        }
    }

    private void initValueClass() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::initValueClass");
        OntResource range = this.property_.getRange();
        if (range.isClass()) {
            this.valueClass_ = (OntClass)range.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = Attribute.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
            OntClass cvClass = this.context_.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#ComplexValue");
            if (cvClass == null) {
                throw new IdASException("Can not find property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#ComplexValue");
            }
            if (ModelUtils.isClassRelative(cvClass, this.valueClass_)) {
                this.isSimple_ = false;
                return;
            }
            OntClass svClass = this.context_.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#SimpleValue");
            if (svClass == null) {
                throw new IdASException("Can not find property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#SimpleValue");
            }
            if (!ModelUtils.isClassRelative(svClass, this.valueClass_)) {
                throw new IdASException("Class " + this.valueClass_.getURI() + " is not a subclass of classes " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#SimpleValue" + " or " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#ComplexValue");
            }
        } else {
            throw new IdASException("Couldn't get range class for attribute property: " + this.property_.getURI());
        }
        this.isSimple_ = true;
    }

    public Individual getOwner() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getOwner");
        return this.owner_;
    }

    public OntClass getOwnerClass() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getOwnerClass");
        return this.ownerClass_;
    }

    public DigitalSubject getSubjectOwner() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getSubjectOwner");
        return this.subject_;
    }

    public DigitalSubject getAttributeProperty() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getSubjectOwner");
        return this.subject_;
    }

    public IComplexAttrValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addComplexValue");
        if (!this.isSimple_) {
            this.context_.registerChangedSubject(this.subject_);
            Individual newValue = this.context_.getModel().createIndividual((Resource)this.valueClass_);
            this.owner_.addProperty((Property)this.property_, (RDFNode)newValue);
            return new ComplexValue(this.context_, this, newValue, this.property_);
        }
        throw new IdASException("Can not create complex value for simple attribute with type " + this.getAttrID().toString());
    }

    public ISimpleAttrValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addSimpleValue");
        if (this.isSimple_) {
            this.context_.registerChangedSubject(this.subject_);
            Individual newValue = this.context_.getModel().createIndividual((Resource)this.valueClass_);
            this.owner_.addProperty((Property)this.property_, (RDFNode)newValue);
            SimpleValue sv = new SimpleValue(this.context_, this, newValue, this.property_);
            sv.setData(data);
            return sv;
        }
        throw new IdASException("Can not create simple value for complex attribute with type " + this.getAttrID().toString());
    }

    public IAttributeValue addValue(URI type) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addValue(URI)");
        if (this.isSimple_) {
            return this.addSimpleValue(type, null);
        }
        return this.addComplexValue(type);
    }

    public IAttributeValue addValue(IAttributeValue copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addValue");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        URI newType = copyFrom.getType();
        if (newType == null) {
            throw new IdASException("Type of passed value \"copyFrom\" is null.");
        }
        if (!newType.equals(this.getAttrID())) {
            throw new IdASException("Can not create value with type " + newType.toString() + " for attribute with type " + this.getAttrID().toString());
        }
        if (this.isSimple_) {
            if (copyFrom instanceof ISimpleAttrValue) {
                ISimpleAttrValue from = (ISimpleAttrValue)copyFrom;
                ISimpleAttrValue newVal = this.addSimpleValue(newType, from.getData());
                Iterator itrMtd = from.getMetadataSet();
                if (itrMtd != null) {
                    while (itrMtd.hasNext()) {
                        IMetadata meta = (IMetadata)itrMtd.next();
                        newVal.addMetadata(meta);
                    }
                }
                return newVal;
            }
            throw new IdASException("Passed value \"copyFrom\" with type " + newType.toString() + " is not an instance of ISimpleValue");
        }
        if (copyFrom instanceof IComplexAttrValue) {
            Iterator itrMtd;
            IComplexAttrValue from = (IComplexAttrValue)copyFrom;
            IComplexAttrValue newVal = this.addComplexValue(newType);
            Iterator itrAttr = from.getAttributes();
            if (itrAttr != null) {
                while (itrAttr.hasNext()) {
                    IAttribute attr = (IAttribute)itrAttr.next();
                    newVal.addAttribute(attr);
                }
            }
            if ((itrMtd = from.getMetadataSet()) != null) {
                while (itrMtd.hasNext()) {
                    IMetadata meta = (IMetadata)itrMtd.next();
                    newVal.addMetadata(meta);
                }
            }
            return newVal;
        }
        throw new IdASException("Passed value \"copyFrom\" with type " + newType.toString() + " is not an instance of IComplexValue");
    }

    public URI getAttrID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getAttrID");
        if (this.type_ == null) {
            this.type_ = URI.create(this.property_.getURI());
        }
        if (this.type_ == null) {
            throw new IdASException("Can not create URI for property " + this.property_.getURI());
        }
        return this.type_;
    }

    public IAttributeModel getModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getModel");
        return this.attModel_;
    }

    public Iterator getValues() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getValues");
        ArrayList<Object> list = new ArrayList<Object>();
        OntClass cvClass = this.context_.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#ComplexValue");
        if (cvClass == null) {
            throw new IdASException("Can not find property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#ComplexValue");
        }
        OntClass svClass = this.context_.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#SimpleValue");
        if (svClass == null) {
            throw new IdASException("Can not find property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#SimpleValue");
        }
        NodeIterator itr = this.owner_.listPropertyValues((Property)this.property_);
        while (itr.hasNext()) {
            RDFNode node = itr.nextNode();
            if (node == null || node.isLiteral()) continue;
            Individual ind = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? Attribute.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            OntClass cls = this.context_.getOntClass(ind.getRDFType().getURI());
            if (ModelUtils.isClassRelative(cvClass, cls)) {
                list.add(new ComplexValue(this.context_, this, ind, this.property_));
                continue;
            }
            if (!ModelUtils.isClassRelative(svClass, cls)) continue;
            list.add(new SimpleValue(this.context_, this, ind, this.property_));
        }
        return list.iterator();
    }

    public boolean isSingleValued() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::isSingleValued");
        return false;
    }

    public void remove() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::remove");
        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
        NodeIterator itr = this.owner_.listPropertyValues((Property)this.property_);
        while (itr.hasNext()) {
            RDFNode node = itr.nextNode();
            list.add(node);
        }
        for (int i = 0; i < list.size(); ++i) {
            RDFNode node = (RDFNode)list.get(i);
            this.owner_.removeProperty((Property)this.property_, node);
            if (node.isLiteral()) continue;
            Individual ind = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? Attribute.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            ModelUtils.removeIndividual(this.context_, ind);
        }
    }

    protected Individual findMetadataContainer() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::findMetadataContainer");
        if (this.metadataHolder_ == null) {
            OntClass attrClass = this.context_.getOntClass("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#Attribute");
            NodeIterator itr = this.owner_.listPropertyValues((Property)this.property_);
            while (itr.hasNext()) {
                Individual ind;
                OntClass cls;
                RDFNode node = itr.nextNode();
                if (node == null || node.isLiteral() || !ModelUtils.isClassRelative(attrClass, cls = this.context_.getOntClass((ind = (Individual)node.as(class$com$hp$hpl$jena$ontology$Individual == null ? Attribute.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual)).getRDFType().getURI()))) continue;
                this.metadataHolder_ = ind;
            }
        }
        return this.metadataHolder_;
    }

    protected Individual findOrCreateMetadataContainer() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::findOrCreateMetadataContainer");
        if (this.metadataHolder_ == null) {
            this.metadataHolder_ = this.findMetadataContainer();
            if (this.metadataHolder_ == null) {
                this.metadataHolder_ = this.context_.getModel().createIndividual((Resource)this.metadataHolderClass_);
                this.owner_.addProperty((Property)this.property_, (RDFNode)this.metadataHolder_);
            }
        }
        return this.metadataHolder_;
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addMetadata(URI)");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(metadataID);
        return newMetadata;
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::addMetadata");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(copyFrom.getID());
        newMetadata.setData(copyFrom.getData());
        return newMetadata;
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getMetadata");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        String uri = metadataID.toString();
        DatatypeProperty prop = this.context_.getDatatypeProperty(uri);
        if (prop == null) {
            throw new IdASException("Can not find datatype property with URI " + uri);
        }
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        if (!ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)prop)) {
            throw new IdASException("Property with URI " + uri + " is not a subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.valueClass_, (OntProperty)prop)) {
            throw new IdASException("Can not add metadata with type " + uri + " for class " + this.valueClass_.getURI());
        }
        Individual metadataHolder = this.findOrCreateMetadataContainer();
        return new Metadata(this.context_, metadataHolder, prop, this.subject_);
    }

    public Iterator getMetadataSet() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.Attribute::getMetadataSet");
        ArrayList<Metadata> list = new ArrayList<Metadata>();
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        Individual metadataHolder = this.findMetadataContainer();
        if (metadataHolder != null) {
            StmtIterator props = metadataHolder.listProperties();
            while (props.hasNext()) {
                Statement st = props.nextStatement();
                Property prop = st.getPredicate();
                DatatypeProperty dpProperty = this.context_.getModel().getDatatypeProperty(prop.getURI());
                if (dpProperty == null || !ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)dpProperty)) continue;
                Metadata md = new Metadata(this.context_, metadataHolder, dpProperty, this.subject_);
                list.add(md);
            }
        }
        return list.iterator();
    }

    public boolean equals(IAttribute attr) throws IdASException {
        return false;
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

