/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextConfiguration
implements IContextConfiguration {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$ContextConfiguration == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$ContextConfiguration = ContextConfiguration.class$("org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration")) : class$org$eclipse$higgins$idas$cp$jena2$impl$ContextConfiguration));
    private String cachePath = null;
    private URI contextRef = null;
    private Properties properties = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$ContextConfiguration;

    public ContextConfiguration(String cachePath, URI contextRef, Properties defaults, Properties properties) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::ContextConfiguration(String, URI, Properties, Properties)");
        this.cachePath = cachePath;
        this.contextRef = contextRef;
        this.setProperties(defaults, properties);
    }

    public ContextConfiguration(Properties properties) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::ContextConfiguration(Properties)");
        this.cachePath = "";
        this.contextRef = URI.create("http://test");
        this.setProperties(new Properties(), properties);
    }

    public ContextConfiguration(String cachePath, Properties defaults, Element e) throws Exception {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::ContextConfiguration(String, Properties, Element)");
        this.cachePath = cachePath;
        this.load(defaults, e);
    }

    public String getCachePath() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getCachePath");
        return this.cachePath;
    }

    public URI getContextRef() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getContextRef");
        return this.contextRef;
    }

    public Properties getProperties() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getProperties");
        return this.properties;
    }

    public void load(Properties defaults, Element e) throws Exception {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::load");
        String uri = e.getAttribute("uri");
        if (uri == null || uri.length() == 0) {
            throw new Exception("Element \"context\" doesn't have \"uri\" attribute");
        }
        this.contextRef = new URI(uri);
        this.setProperties(defaults, this.loadProperties(e));
    }

    public void store(Element e) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::store");
        e.setAttribute("uri", this.getContextRef().toString());
        this.saveProperties(e);
    }

    public String getProperty(String key) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getProperty");
        String res = null;
        if (this.properties != null) {
            res = this.properties.getProperty(key);
        }
        return res;
    }

    public List getPropertyNames() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getPropertyNames");
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Object> itr = this.properties.keySet().iterator();
        while (itr.hasNext()) {
            list.add((String)itr.next());
        }
        return list;
    }

    public String getProperty(String key, String defaultValue) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::getProperty");
        String res = defaultValue;
        if (this.properties != null) {
            res = this.properties.getProperty(key, defaultValue);
        }
        return res;
    }

    private void setProperties(Properties defaults, Properties properties) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::setProperties");
        this.properties = new Properties(defaults);
        Iterator<Object> itr = properties.keySet().iterator();
        while (itr.hasNext()) {
            String k = (String)itr.next();
            this.properties.setProperty(k, properties.getProperty(k));
        }
    }

    private Properties loadProperties(Element e) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::loadProperties");
        Properties props = new Properties();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            String name;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("parameter") || (name = (el = (Element)node).getAttribute("name")).length() <= 0) continue;
            String value = el.getAttribute("value");
            props.put(name, value);
        }
        return props;
    }

    private void saveProperties(Element e) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration::saveProperties");
        Document doc = e.getOwnerDocument();
        List itrbl = this.getPropertyNames();
        if (itrbl != null) {
            Iterator itr = itrbl.iterator();
            while (itr.hasNext()) {
                String n = (String)itr.next();
                String v = this.getProperty(n);
                Element p = doc.createElement("parameter");
                p.setAttribute("name", n);
                p.setAttribute("value", v);
                e.appendChild(p);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

