/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IDigitalSubject;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDigitalSubjectModel;
import org.eclipse.higgins.idas.cp.jena2.IJenaContext;
import org.eclipse.higgins.idas.cp.jena2.impl.Attribute;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.Metadata;
import org.eclipse.higgins.idas.cp.jena2.impl.SingleValuedAttribute;
import org.eclipse.higgins.idas.cp.jena2.util.HigginsVocabulary;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeModel;

public class DigitalSubject
implements IDigitalSubject {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$DigitalSubject == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$DigitalSubject = DigitalSubject.class$("org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject")) : class$org$eclipse$higgins$idas$cp$jena2$impl$DigitalSubject));
    protected Context context_ = null;
    protected IDigitalSubjectModel model_ = null;
    protected Individual subject_ = null;
    protected OntClass ontClass_ = null;
    protected URI type_ = null;
    protected String userToken_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$DigitalSubject;

    public DigitalSubject(Context context, Individual subject) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::DigitalSubject");
        if (context == null) {
            throw new IdASException("Couldn't create DigitalSubject with null IContext");
        }
        if (subject == null) {
            throw new IdASException("Couldn't create DigitalSubject for null subject individual");
        }
        this.context_ = context;
        this.subject_ = subject;
        this.ontClass_ = context.getOntClass(subject.getRDFType().getURI());
        URI type = this.getType();
        this.model_ = this.context_.getContextModel().getSubjectModel(type);
        if (this.model_ == null) {
            throw new IdASException("Can not get subject model for DS URI " + type.toString());
        }
        this.userToken_ = ModelUtils.getUserToken(this.context_, this.subject_);
    }

    public IContext getContext() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getContext");
        return this.context_;
    }

    public IJenaContext getJenaContext() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getJenaContext");
        return this.context_;
    }

    public Individual getSubjectIndividual() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getSubjectIndividual");
        return this.subject_;
    }

    public IDigitalSubjectModel getModel() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getModel");
        return this.model_;
    }

    public String getSubjectID() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getSubjectID");
        IAttribute sAttr = this.getAttribute(HigginsVocabulary.uniqueIdentifierURI);
        if (sAttr == null) {
            throw new IdASException("Attributehttp://www.eclipse.org/higgins/ontologies/2006/higgins.owl#uniqueIdentifier was not found");
        }
        IAttributeValue val = null;
        Iterator itr = sAttr.getValues();
        if (itr != null && itr.hasNext()) {
            val = (IAttributeValue)itr.next();
        }
        if (val == null) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#uniqueIdentifier is null");
        }
        if (!val.isSimple()) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#uniqueIdentifier is not SimpleValue");
        }
        Object data = ((ISimpleAttrValue)val).getData();
        if (data == null) {
            throw new IdASException("Value of attribute http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#uniqueIdentifier contains null data");
        }
        return data.toString();
    }

    public URI getType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getType");
        if (this.type_ == null) {
            this.type_ = URI.create(this.ontClass_.getURI());
        }
        return this.type_;
    }

    public void remove() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::remove");
        this.context_.unregisterChangedSubject(this);
        ModelUtils.removeIndividual(this.context_, this.subject_);
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::addMetadata");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(metadataID);
        return newMetadata;
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::addMetadata");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IMetadata newMetadata = this.getMetadata(copyFrom.getID());
        newMetadata.setData(copyFrom.getData());
        this.context_.registerChangedSubject(this);
        return newMetadata;
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getMetadata");
        if (metadataID == null) {
            throw new IdASException("Parameter \"metadataID\" is null.");
        }
        String uri = metadataID.toString();
        DatatypeProperty prop = this.context_.getDatatypeProperty(uri);
        if (prop == null) {
            throw new IdASException("Can not find datatype property with URI " + uri);
        }
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        if (!ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)prop)) {
            throw new IdASException("Property with URI " + uri + " is not a subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.ontClass_, (OntProperty)prop)) {
            throw new IdASException("Can not add metadata with type " + uri + " for class " + this.ontClass_.getURI());
        }
        return new Metadata(this.context_, this.subject_, prop, this);
    }

    public Iterator getMetadataSet() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getMetadataSet");
        ArrayList<Metadata> list = new ArrayList<Metadata>();
        DatatypeProperty metadata = this.context_.getDatatypeProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        if (metadata == null) {
            throw new IdASException("Can not find datatype property with URI http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#simpleMetadata");
        }
        StmtIterator props = this.subject_.listProperties();
        while (props.hasNext()) {
            Statement st = props.nextStatement();
            Property prop = st.getPredicate();
            DatatypeProperty dpProperty = this.context_.getModel().getDatatypeProperty(prop.getURI());
            if (dpProperty == null || !ModelUtils.isPropertyRelative((OntProperty)metadata, (OntProperty)dpProperty)) continue;
            Metadata md = new Metadata(this.context_, this.subject_, dpProperty, this);
            list.add(md);
        }
        return list.iterator();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::addAttribute");
        return this.getAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::addAttribute");
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        IAttribute newAttr = this.getAttribute(copyFrom.getAttrID());
        this.context_.registerChangedSubject(this);
        Iterator itrVal = copyFrom.getValues();
        while (itrVal.hasNext()) {
            IAttributeValue value = (IAttributeValue)itrVal.next();
            newAttr.addValue(value);
        }
        Iterator itrMd = copyFrom.getMetadataSet();
        while (itrMd.hasNext()) {
            IMetadata metadata = (IMetadata)itrMd.next();
            newAttr.addMetadata(metadata);
        }
        return newAttr;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getAttribute");
        if (attrID == null) {
            throw new IdASException("Parameter \"attrID\" is null.");
        }
        String uri = attrID.toString();
        OntProperty op = this.context_.getOntProperty(uri);
        ObjectProperty attrProp = this.context_.getObjectProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        if (!ModelUtils.isPropertyRelative((OntProperty)attrProp, op)) {
            throw new InvalidTypeException("Property " + uri + " is not subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        }
        if (!ModelUtils.isPropertyOfClass(this.context_, this.ontClass_, op)) {
            throw new InvalidTypeException("Can not create attribute with type " + uri + " for DigitalSubject with type " + this.ontClass_.getURI());
        }
        AttributeModel attrModel = (AttributeModel)this.model_.getAttributeModel(attrID);
        if (attrModel == null) {
            throw new IdASException("Can not get model of attribute with type " + uri + " for DigitalSubject with type " + this.ontClass_.getURI());
        }
        int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.ontClass_, op);
        if (maxCardinality == 1) {
            return new SingleValuedAttribute(this.context_, this, op, (IAttributeModel)attrModel);
        }
        return new Attribute(this.context_, this, op, (IAttributeModel)attrModel);
    }

    public Iterator getAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getAttributes");
        ObjectProperty attrProp = this.context_.getObjectProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        HashSet<String> usedURIs = new HashSet<String>();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        StmtIterator props = this.subject_.listProperties();
        while (props.hasNext()) {
            Statement st = props.nextStatement();
            Property prop = st.getPredicate();
            String uri = prop.getURI();
            ObjectProperty property = this.context_.getModel().getObjectProperty(uri);
            if (property == null || usedURIs.contains(uri) || !ModelUtils.isPropertyRelative((OntProperty)attrProp, (OntProperty)property)) continue;
            AttributeModel attrModel = (AttributeModel)this.model_.getAttributeModel(URI.create(uri));
            if (attrModel == null) {
                throw new IdASException("Can not get model of attribute with type " + uri + " for DigitalSubject with type " + this.ontClass_.getURI());
            }
            int maxCardinality = ModelUtils.getMaxCardinality(this.context_, this.ontClass_, (OntProperty)property);
            if (maxCardinality == 1) {
                attrs.add(new SingleValuedAttribute(this.context_, this, (OntProperty)property, (IAttributeModel)attrModel));
            } else {
                attrs.add(new Attribute(this.context_, this, (OntProperty)property, (IAttributeModel)attrModel));
            }
            usedURIs.add(uri);
        }
        return attrs.iterator();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getSingleValuedAttribute");
        String idURI = attrID.toString();
        IAttribute attr = this.getAttribute(attrID);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof ISingleValuedAttribute)) {
            throw new IdASException("Attribute " + idURI + " is not an instance of ISingleValuedAttribute");
        }
        return (ISingleValuedAttribute)attr;
    }

    public String getUserToken() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::getUserToken");
        return this.userToken_;
    }

    public boolean equals(Object obj) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.DigitalSubject::equals");
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DigitalSubject)) {
            return false;
        }
        DigitalSubject ds = (DigitalSubject)obj;
        return this.subject_.equals(ds.getSubjectIndividual());
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return false;
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return false;
    }

    public void removeAttribute(URI attrID) throws IdASException {
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

