/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.IFactoryConfiguration;
import org.eclipse.higgins.idas.cp.jena2.impl.ContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.util.ConfigUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FactoryConfiguration
implements IFactoryConfiguration {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$FactoryConfiguration == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$FactoryConfiguration = FactoryConfiguration.class$("org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration")) : class$org$eclipse$higgins$idas$cp$jena2$impl$FactoryConfiguration));
    private Properties defaults = null;
    private String id = null;
    private String cachePath = null;
    public Hashtable configTable = new Hashtable();
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$FactoryConfiguration;

    public FactoryConfiguration(String id) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::FactoryConfiguration");
        this.id = id;
        this.loadDefaults();
    }

    public Properties getDefaultProperties() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::getDefaultProperties");
        return (Properties)this.defaults.clone();
    }

    public List getContextRefs() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::getContextRefs");
        return new ArrayList(this.configTable.keySet());
    }

    public IContextConfiguration getContextConfig(URI key) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::getContextConfig");
        if (key == null) {
            return null;
        }
        return (IContextConfiguration)this.configTable.get(key);
    }

    public void setContextConfig(IContextConfiguration config) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::setContextConfig");
        this.configTable.put(config.getContextRef(), config);
    }

    public void addContextConfig(URI contextRef, Properties p) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::addContextConfig");
        if (!this.configTable.containsKey(contextRef)) {
            this.setContextConfig(this.createContextConfig(contextRef, p));
        }
    }

    public void removeContextConfig(URI contextRef) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::removeContextConfig");
        if (this.configTable.containsKey(contextRef)) {
            this.configTable.remove(contextRef);
        }
    }

    public IContextConfiguration createContextConfig(URI contextRef, Properties p) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::createContextConfig");
        return new ContextConfiguration(this.cachePath, contextRef, this.defaults, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(File config) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::load");
        FileInputStream in = null;
        in = new FileInputStream(config);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        DocumentBuilder db = dbf.newDocumentBuilder();
        doc = db.parse(new InputSource(in));
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (id != null && !id.equals(this.id)) {
            System.out.println("Warning: factory id doesn't match - " + this.id + "!=" + id);
        }
        this.cachePath = ConfigUtil.resolvePath(root.getAttribute("cacheLocation"));
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if (el.getNodeName().equals("context")) {
                try {
                    String uri = el.getAttribute("uri");
                    if (uri.length() <= 0) continue;
                    this.setContextConfig(new ContextConfiguration(this.cachePath, this.defaults, el));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!el.getNodeName().equals("default")) continue;
            this.updateDefaults(this.loadProperties(el));
        }
        Object var14_15 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var14_16 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(File config) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::save");
        OutputStreamWriter writer = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("factory");
        root.setAttribute("id", this.id);
        root.setAttribute("cacheLocation", this.cachePath);
        doc.appendChild(root);
        Element e = doc.createElement("default");
        root.appendChild(e);
        this.saveProperties(e, this.defaults);
        Iterator itr = this.configTable.keySet().iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            IContextConfiguration cfg = (IContextConfiguration)this.configTable.get(key);
            e = doc.createElement("context");
            root.appendChild(e);
            cfg.store(e);
        }
        OutputFormat format = new OutputFormat(doc);
        format.setLineSeparator("\r\n");
        format.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer((OutputStream)new FileOutputStream(config), format);
        serializer.asDOMSerializer();
        serializer.serialize(doc);
        Object var12_12 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (Exception e3) {
                e3.printStackTrace();
                Object var12_13 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public String getCachePath() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::getCachePath");
        return this.cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDefaults() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::loadDefaults");
        this.defaults = new Properties();
        InputStream is = null;
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.id + ".properties");
        this.defaults.load(is);
        Object var4_2 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var4_3 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    private Properties loadProperties(Element e) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::loadProperties");
        Properties props = new Properties();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el;
            String name;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("parameter") || (name = (el = (Element)node).getAttribute("name")).length() <= 0) continue;
            String value = el.getAttribute("value");
            props.put(name, value);
        }
        return props;
    }

    private void saveProperties(Element e, Properties properties) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::saveProperties");
        Document doc = e.getOwnerDocument();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            String v = properties.getProperty(n);
            Element p = doc.createElement("parameter");
            p.setAttribute("name", n);
            p.setAttribute("value", v);
            e.appendChild(p);
        }
    }

    private void updateDefaults(Properties properties) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FactoryConfiguration::updateDefaults");
        Enumeration<?> en = this.defaults.propertyNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            String v = properties.getProperty(n, this.defaults.getProperty(n));
            this.defaults.setProperty(n, v);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

