/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl;

import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IModel;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.util.ConfigUtil;

public class FileContext
extends Context {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$FileContext == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$FileContext = FileContext.class$("org.eclipse.higgins.idas.cp.jena2.impl.FileContext")) : class$org$eclipse$higgins$idas$cp$jena2$impl$FileContext));
    protected File contextFile_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$FileContext;

    public FileContext() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::FileContext");
    }

    public FileContext(IContextConfiguration config) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::FileContext(IContextConfiguration)");
        this.initialize(config);
    }

    public FileContext(IContextId contextID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::FileContext(IContextId)");
        this.initialize(contextID);
    }

    public void initialize(IContextId contextID) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::initialize(IContextId)");
        if (contextID == null) {
            throw new IdASException("Parameter \"contextID\" is null.");
        }
        Map config = contextID.getConfiguration();
        try {
            this.contextFile_ = new File((String)config.get("context.file"));
            this.ns_ = (String)config.get("context.uri");
            String schemaCache = (String)config.get("schema.cache");
            this.setSchemaURI((String)config.get("schema.url"), ConfigUtil.getFilePath((String)config.get("schema.file"), schemaCache));
        }
        catch (ClassCastException e) {
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
    }

    private String getProp(Properties props, String propertyName) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::getProp");
        if (props == null) {
            throw new IdASException("Parameter props is null");
        }
        if (props.containsKey(propertyName)) {
            return props.get(propertyName).toString();
        }
        throw new IdASException("Property " + propertyName + " was not found");
    }

    public void init(Properties props) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::init");
        this.contextFile_ = new File(this.getProp(props, "context.file"));
        this.schemaURL_ = this.getProp(props, "schema.url");
        this.schemaFileName_ = this.getProp(props, "schema.file");
        this.ns_ = this.getProp(props, "uri");
    }

    public void initialize(IContextConfiguration config) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::initialize(IContextConfiguration)");
        this.contextFile_ = new File(config.getProperty("context.file"));
        if (this.contextFile_ == null) {
            throw new IdASException("Invalid context configuration: contextRef=" + config.getContextRef() + " context.file=" + this.contextFile_);
        }
        this.ns_ = config.getContextRef().toString();
        if (this.ns_ == null) {
            throw new IdASException("Invalid context configuration: contextRef=" + config.getContextRef());
        }
        this.setSchemaURI(config.getProperty("schema.url"), ConfigUtil.getFilePath(config.getProperty("schema.file"), config.getCachePath()));
    }

    private void loadOntology() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::loadOntology");
        FileInputStream fis = null;
        try {
            this.model_ = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            fis = new FileInputStream(this.contextFile_);
            this.model_.read((InputStream)fis, this.ns_);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)e);
            throw new IdASException((Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
    }

    private void createOntology() throws IdASException {
        File fileSchema;
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::createOntology");
        this.model_ = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        if (this.schemaFileName_ != null && this.schemaFileName_.trim().length() > 0 && (fileSchema = new File(this.schemaFileName_)).exists() && fileSchema.isFile()) {
            this.model_.getDocumentManager().addAltEntry(this.schemaURL_, this.schemaFileName_);
        }
        this.model_.setDynamicImports(true);
        String schema = this.getSchemaURI();
        if (schema == null) {
            throw new IdASException("Couldn't get schema URI");
        }
        this.model_.createOntology(schema);
        Resource imp = this.model_.createResource(schema);
        Property importProp = this.model_.getProperty("http://www.w3.org/2002/07/owl#imports");
        Ontology ont = this.model_.createOntology("");
        ont.addProperty(importProp, (RDFNode)imp);
        Model baseModel = this.model_.getBaseModel();
        baseModel.setNsPrefix("schema", this.schemaURL_);
        ExtendedIterator ei = this.model_.listImportedModels();
        while (ei.hasNext()) {
            Model m = (Model)ei.next();
            Map nsMap = m.getNsPrefixMap();
            Iterator keys = nsMap.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)nsMap.get(key);
                if (baseModel.getNsURIPrefix(value) != null) continue;
                baseModel.setNsPrefix(key, value);
            }
        }
    }

    protected void init() throws IdASException {
        block4: {
            this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::init");
            try {
                if (this.contextFile_.exists()) {
                    this.loadOntology();
                    break block4;
                }
                if (this.schemaURL_ != null) {
                    this.createOntology();
                    break block4;
                }
                throw new IdASException("Couldn't create context without schema");
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException((Throwable)e);
            }
        }
    }

    protected void save() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::save");
        FileOutputStream fos = null;
        RDFWriter w = this.model_.getWriter("RDF/XML-ABBREV");
        w.setProperty("showXmlDeclaration", (Object)"true");
        w.setProperty("xmlbase", (Object)this.ns_);
        w.setProperty("allowBadURIs", (Object)"true");
        w.setProperty("relativeURIs", (Object)"same-document,relative");
        try {
            File dir = this.contextFile_.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            File tmpFile = File.createTempFile("tmp", ".$");
            fos = new FileOutputStream(tmpFile);
            w.write(this.model_.getBaseModel(), (OutputStream)fos, this.ns_);
            fos.flush();
            fos.close();
            if (this.contextFile_.exists() && !this.contextFile_.delete()) {
                throw new IdASException("Couldn't save context");
            }
            tmpFile.renameTo(this.contextFile_);
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
            }
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
    }

    public boolean isTransactionSupported() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::isTransactionSupported");
        return true;
    }

    public void begin() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::begin");
    }

    public void commit() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::commit");
        this.save();
    }

    public void rollback() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::rollback");
        this.init();
    }

    public void cancelUpdates() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.FileContext::cancelUpdates");
        this.rollback();
    }

    public IModel getModel(URI elementType) throws IdASException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

