/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl.authentication;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.cp.jena2.IAuthenticationModule;
import org.eclipse.higgins.idas.cp.jena2.IUserAccount;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.authentication.PasswordBasedUserAccount;

public class AuthenticationModule
implements IAuthenticationModule {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule = AuthenticationModule.class$("org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule")) : class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule));
    protected OntModel model_ = null;
    protected OntClass accountClass_ = null;
    protected OntProperty nameProperty_ = null;
    protected OntProperty passwordHashProperty_ = null;
    protected OntProperty tokenProperty_ = null;
    protected Context context_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$authentication$AuthenticationModule;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Literal;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    public AuthenticationModule(Context context) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::AuthenticationModule");
        if (context == null) {
            throw new IdASException("The parameter \"model\" is null");
        }
        this.context_ = context;
        this.model_ = context.getModelNoException();
        this.accountClass_ = this.initClass("http:/test/UserAccount");
        this.nameProperty_ = this.initProperty("http:/test/userLogin");
        this.passwordHashProperty_ = this.initProperty("http:/test/userPasswordHash");
        this.tokenProperty_ = this.initProperty("http:/test/userToken");
    }

    public IUserAccount authenticate(Object credentials) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::authenticate");
        if (credentials instanceof AuthNNamePasswordMaterials) {
            AuthNNamePasswordMaterials am = (AuthNNamePasswordMaterials)credentials;
            String name = am.getUsername();
            if (name == null) {
                throw new IdASException("AuthNNamePasswordMaterials contains null username.");
            }
            if ((name = name.trim()).length() == 0) {
                throw new IdASException("AuthNNamePasswordMaterials contains empty string username.");
            }
            String password = am.getPassword();
            ArrayList list = this.getSubjectIndividuals(name);
            Individual userInd = null;
            switch (list.size()) {
                case 0: {
                    try {
                        userInd = this.createNewAccount(name, password);
                        this.context_.applyUpdates();
                        break;
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                        this.context_.cancelUpdates();
                        throw new IdASException();
                    }
                }
                case 1: {
                    try {
                        userInd = (Individual)list.get(0);
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                        throw new IdASException(e.getMessage());
                    }
                    this.checkPassword(userInd, password);
                    break;
                }
                default: {
                    throw new IdASException("There are more then one user with name = " + name);
                }
            }
            return new PasswordBasedUserAccount(this.model_, userInd, am);
        }
        throw new IdASException("Unsupported credentials type.");
    }

    private Individual createNewAccount(String name, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::createNewAccount");
        Individual userInd = this.model_.createIndividual((Resource)this.accountClass_);
        Literal nameLtr = this.model_.createLiteral(name);
        userInd.setPropertyValue((Property)this.nameProperty_, (RDFNode)nameLtr);
        String token = name;
        Literal tokenLtr = this.model_.createLiteral(token);
        userInd.setPropertyValue((Property)this.tokenProperty_, (RDFNode)tokenLtr);
        this.setNewPassword(userInd, password);
        return userInd;
    }

    private void setNewPassword(Individual user, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::setNewPassword");
        String newHash = null;
        byte[] bytes = this.getHash(password);
        if (bytes != null) {
            newHash = Base64.encode((byte[])bytes);
        }
        if (newHash != null) {
            Literal ltr = this.model_.createLiteral(newHash);
            user.setPropertyValue((Property)this.passwordHashProperty_, (RDFNode)ltr);
        } else {
            RDFNode node = user.getPropertyValue((Property)this.passwordHashProperty_);
            if (node != null) {
                user.removeProperty((Property)this.passwordHashProperty_, node);
            }
        }
    }

    private void checkPassword(Individual userInd, String password) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::checkPassword");
        String passHash = null;
        RDFNode rdfNode = userInd.getPropertyValue((Property)this.passwordHashProperty_);
        if (!rdfNode.isLiteral()) {
            throw new IdASException("Value of property " + this.passwordHashProperty_.getURI() + " is not literal.");
        }
        Literal litr = (Literal)rdfNode.as(class$com$hp$hpl$jena$rdf$model$Literal == null ? (class$com$hp$hpl$jena$rdf$model$Literal = AuthenticationModule.class$("com.hp.hpl.jena.rdf.model.Literal")) : class$com$hp$hpl$jena$rdf$model$Literal);
        Object obj = litr.getValue();
        if (obj != null) {
            passHash = obj.toString();
        }
        if (passHash == null || passHash.length() == 0) {
            if (password != null && password.length() > 0) {
                throw new IdASException("Wrong password.");
            }
        } else {
            if (password == null || password.length() == 0) {
                throw new IdASException("Wrong password.");
            }
            byte[] realPassHash = null;
            byte[] testedHash = null;
            testedHash = this.getHash(password);
            try {
                realPassHash = Base64.decode((String)passHash);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
            if (!Arrays.equals(realPassHash, testedHash)) {
                throw new IdASException("Wrong password.");
            }
        }
    }

    private OntClass initClass(String name) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::initClass");
        OntClass ontClass = this.model_.getOntClass(name);
        if (ontClass == null) {
            try {
                ontClass = this.model_.createClass(name);
                this.context_.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                this.context_.cancelUpdates();
                throw new IdASException();
            }
        }
        return ontClass;
    }

    private OntProperty initProperty(String name) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::initProperty");
        OntProperty prop = this.model_.getOntProperty(name);
        if (prop == null) {
            try {
                prop = this.model_.createDatatypeProperty(name);
                this.context_.applyUpdates();
            }
            catch (Exception e) {
                this.log.error((Object)e);
                this.context_.cancelUpdates();
                throw new IdASException();
            }
        }
        return prop;
    }

    private byte[] getHash(String str) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::getHash");
        if (str != null && str.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return md.digest(str.getBytes("UTF-8"));
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new IdASException(e.getMessage());
            }
        }
        return null;
    }

    public ArrayList getSubjectIndividuals(String userName) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.authentication.AuthenticationModule::getSubjectIndividuals");
        String query = "SELECT ?ind \nWHERE { \n  ?ind <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http:/test/UserAccount>. \n  ?ind <http:/test/userLogin> \"" + userName + "\" \n" + "}";
        this.log.debug((Object)query);
        ArrayList<Individual> list = new ArrayList<Individual>();
        Query q = QueryFactory.create((String)query);
        QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.context_.getModelNoException());
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode a = soln.get("ind");
                Individual digitalSubject = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? AuthenticationModule.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                list.add(digitalSubject);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        finally {
            qexec.close();
        }
        this.log.debug((Object)("Users count by query: " + list.size()));
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

