/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.BadFilterException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.AttributeNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.LiteralNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.ValueCondition;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;

public class FilterAttributeAssertion
extends FilterAssertion
implements IFilterAttributeAssertion {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterAttributeAssertion == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterAttributeAssertion = FilterAttributeAssertion.class$("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion")) : class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterAttributeAssertion));
    private CompoundCondition condition_ = null;
    private Filter metadataFilter_ = null;
    private Context idasContext_ = null;
    private FilterContext filterContext_ = null;
    protected IAttributeValue value_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterAttributeAssertion;

    public FilterAttributeAssertion(Context context) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::FilterAttributeAssertion");
        this.idasContext_ = context;
    }

    public void setMetadataFilter(IFilter metadataFilter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::setMetadataFilter");
        if (!(metadataFilter instanceof Filter)) {
            throw new BadFilterException("Filter created by another context provider implementation cannot be added");
        }
        this.metadataFilter_ = (Filter)metadataFilter;
    }

    public IFilter getMetadataFilter() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::getMetadataFilter");
        return this.metadataFilter_;
    }

    public ICondition getCondition() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::getCondition");
        if (this.condition_ == null) {
            throw new IdASException("Can't return condition. FilterAttributeAssertion should be initialized before.");
        }
        return this.condition_;
    }

    public void setAssertionValue(IAttributeValue assertionValue) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::setAssertionValue");
        this.value_ = assertionValue;
    }

    private void initWithSimpleValue(ISimpleAttrValue val, CompoundCondition condition, AttributeNode attributeNode, GraphPattern parent) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::initWithSimpleValue");
        PropertyNode xmlProp = new PropertyNode(ModelUtils.getSimpleValuePropertyByXMLType(this.idasContext_, val.getType()));
        GraphPattern pattern = this.filterContext_.registerPattern(new GraphPattern(attributeNode, xmlProp, new LiteralNode(), parent));
        condition.addCondition(new ValueCondition((LiteralNode)pattern.getObject(), this.comparator_, (ITypedValue)val));
    }

    private void initWithComplexValue(IComplexAttrValue val, CompoundCondition condition, AttributeNode attributeNode, GraphPattern parent) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::initWithComplexValue");
        Iterator itAttr = val.getAttributes();
        if (itAttr != null) {
            while (itAttr.hasNext()) {
                IAttribute attr = (IAttribute)itAttr.next();
                Iterator itVal = attr.getValues();
                if (itVal == null) continue;
                while (itVal.hasNext()) {
                    IAttributeValue value = (IAttributeValue)itVal.next();
                    if (value == null) continue;
                    if (value.isSimple()) {
                        ISimpleAttrValue simple = (ISimpleAttrValue)value;
                        this.initWithSimpleValue(simple, condition, attributeNode, parent);
                        continue;
                    }
                    IComplexAttrValue complexVal = (IComplexAttrValue)value;
                    URI attrType = attr.getAttrID();
                    if (attrType == null) {
                        throw new IdASException("Attribute type is null.");
                    }
                    AttributeNode newAttributeNode = new AttributeNode();
                    PropertyNode newPropNode = new PropertyNode(attrType.toString());
                    GraphPattern newPattern = this.filterContext_.registerPattern(new GraphPattern(attributeNode, newPropNode, newAttributeNode, parent));
                    this.initWithComplexValue(complexVal, condition, newAttributeNode, newPattern);
                }
            }
        }
    }

    public void init(FilterContext filterContext) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::init");
        this.filterContext_ = filterContext;
        if (this.idasContext_ == null) {
            throw new IdASException("Can't init FilterAttributeAssertion because context is null.");
        }
        if (this.value_ == null) {
            throw new IdASException("Can't init FilterAttributeAssertion because value is null.");
        }
        if (this.type_ == null) {
            throw new IdASException("Can't init FilterAttributeAssertion because type is null.");
        }
        if (this.comparator_ == null) {
            throw new IdASException("Can't init FilterAttributeAssertion because comparator is null.");
        }
        GraphPattern pattern = null;
        String type = this.type_.toString();
        this.condition_ = new CompoundCondition("urn:eclipse.higgins.idas.OP_AND");
        ArrayList<String> types = new ArrayList<String>();
        types.add(type);
        if (this.includeSubtypes_) {
            OntProperty prop = this.idasContext_.getOntProperty(type);
            ExtendedIterator it = prop.listSubProperties();
            while (it.hasNext()) {
                OntProperty subProp = (OntProperty)it.next();
                types.add(subProp.getURI());
            }
        }
        CompoundCondition valuesCondition = new CompoundCondition("urn:eclipse.higgins.idas.OP_OR");
        this.condition_.addCondition(valuesCondition);
        int typesCount = types.size();
        for (int i = 0; i < typesCount; ++i) {
            ISimpleAttrValue val;
            CompoundCondition valueCondition = new CompoundCondition("urn:eclipse.higgins.idas.OP_AND");
            valuesCondition.addCondition(valueCondition);
            String subType = (String)types.get(i);
            PropertyNode propNode = new PropertyNode(subType);
            AttributeNode attributeNode = new AttributeNode();
            pattern = this.filterContext_.registerPattern(new GraphPattern(this.filterContext_.getSubjectNode(), propNode, attributeNode, null));
            if (this.value_ instanceof ISimpleAttrValue) {
                val = (ISimpleAttrValue)this.value_;
                this.initWithSimpleValue(val, valueCondition, attributeNode, pattern);
            } else if (this.value_ instanceof IComplexAttrValue) {
                val = (IComplexAttrValue)this.value_;
                this.initWithComplexValue((IComplexAttrValue)val, valueCondition, attributeNode, pattern);
            } else {
                throw new IdASException("Unexpected type of assertion value : " + this.value_.getClass().getName());
            }
            if (this.metadataFilter_ == null) continue;
            this.metadataFilter_.initAsAttributeMetadataFilter(pattern, filterContext);
            this.condition_.addCondition(this.metadataFilter_.getCondition());
        }
    }

    public void setID(URI type) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAttributeAssertion::setID(URI)");
        if (type == null) {
            throw new IdASException("Parameter \"type\" is null.");
        }
        String uri = type.toString();
        ObjectProperty attrType = this.idasContext_.getObjectProperty(uri);
        if (attrType == null) {
            throw new IdASException("Couldn't find object property : " + uri);
        }
        OntProperty higginsAttr = this.idasContext_.getOntProperty("http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        if (!ModelUtils.isPropertyRelative(higginsAttr, (OntProperty)attrType)) {
            throw new IdASException("Property  " + uri + " is not a subproperty of " + "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#attribute");
        }
        this.type_ = type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

