/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IUserAccount;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.Filter;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.GraphPattern;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.INode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.LiteralNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.PropertyNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.SubjectNode;
import org.eclipse.higgins.idas.cp.jena2.impl.filter.UntypedValueCondition;

public class FilterContext {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterContext == null ? (class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterContext = FilterContext.class$("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext")) : class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterContext));
    private int varIndex_ = 0;
    private Hashtable pathToPattern_;
    private SubjectNode subjectNode_;
    private Context idasContext_;
    private ICondition queryCondition_;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$jena2$impl$filter$FilterContext;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;

    public FilterContext(Context idasContext) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::FilterContext");
        this.idasContext_ = idasContext;
    }

    public Context getIdASContext() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getIdASContext");
        return this.idasContext_;
    }

    public int getNextIndex() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getNextIndex");
        return this.varIndex_++;
    }

    public SubjectNode getSubjectNode() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getSubjectNode");
        return this.subjectNode_;
    }

    public GraphPattern registerPattern(GraphPattern pattern) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::registerPattern");
        String fullPath = pattern.getFullPath();
        if (this.pathToPattern_.containsKey(fullPath)) {
            return (GraphPattern)this.pathToPattern_.get(fullPath);
        }
        this.pathToPattern_.put(fullPath, pattern);
        return pattern;
    }

    private void indexNode(INode node) {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::indexNode");
        if (node.indexRequired() && !node.hasIndex()) {
            node.setIndex(this.getNextIndex());
        }
    }

    private void indexNodes() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::indexNodes");
        Iterator it = this.pathToPattern_.values().iterator();
        while (it.hasNext()) {
            GraphPattern pattern = (GraphPattern)it.next();
            this.indexNode(pattern.getObject());
            this.indexNode(pattern.getPredicate());
            this.indexNode(pattern.getSubject());
        }
    }

    private ArrayList getSortedPatternPaths() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getSortedPatternPaths");
        ArrayList list = new ArrayList();
        Enumeration keys = this.pathToPattern_.keys();
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        Collections.sort(list);
        return list;
    }

    private StringBuffer getPatterns() {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getPatterns");
        StringBuffer buf = new StringBuffer();
        ArrayList list = this.getSortedPatternPaths();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)list.get(i);
            buf.append("\t\t");
            GraphPattern pattern = (GraphPattern)this.pathToPattern_.get(key);
            buf.append(pattern.asQueryElement());
            buf.append(". \n");
        }
        return buf;
    }

    private String assembleQuery() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::assembleQuery");
        StringBuffer buf = new StringBuffer();
        buf.append("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n");
        buf.append("SELECT ");
        buf.append(this.subjectNode_.asQueryElement());
        buf.append("\n");
        buf.append("WHERE {\n");
        buf.append("\tOPTIONAL { \n");
        buf.append(this.getPatterns());
        buf.append("\t}\n");
        buf.append("\tFILTER\n");
        buf.append(this.queryCondition_.getCondition());
        buf.append("}\n");
        return buf.toString();
    }

    public List getSubjectIndividuals(Filter filter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getSubjectIndividuals");
        String query = this.getRDFQuery(filter);
        this.log.debug((Object)query);
        ArrayList<Individual> list = new ArrayList<Individual>();
        Query q = QueryFactory.create((String)query);
        QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.idasContext_.getModel());
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                RDFNode a = soln.get("subj");
                Individual digitalSubject = (Individual)a.as(class$com$hp$hpl$jena$ontology$Individual == null ? FilterContext.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                list.add(digitalSubject);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new IdASException(e.getMessage());
        }
        finally {
            qexec.close();
        }
        this.log.debug((Object)("Number of selected digital subject individuals by query : " + list.size()));
        return list;
    }

    private synchronized String getRDFQuery(Filter filter) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::getRDFQuery");
        this.subjectNode_ = new SubjectNode();
        this.varIndex_ = 1;
        this.pathToPattern_ = new Hashtable();
        filter.init(this);
        this.queryCondition_ = filter.getCondition();
        this.addUserTokenToQuery();
        this.queryCondition_.setLevel(0);
        this.indexNodes();
        return this.assembleQuery();
    }

    public void addUserTokenToQuery() throws IdASException {
        String userToken;
        this.log.trace((Object)"org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext::addUserTokenToQuery");
        IUserAccount account = this.idasContext_.getUserAccount();
        if (account != null && (userToken = account.getUserToken()) != null && !"".equals(userToken.trim())) {
            GraphPattern pattern = this.registerPattern(new GraphPattern(this.getSubjectNode(), new PropertyNode("http:/test/userToken"), new LiteralNode(), null));
            CompoundCondition cc = new CompoundCondition("urn:eclipse.higgins.idas.OP_AND");
            cc.addCondition(this.queryCondition_);
            cc.addCondition(new UntypedValueCondition((LiteralNode)pattern.getObject(), "urn:org.eclipse.higgins.idas.api.comparator.attribute.equality", userToken));
            this.queryCondition_ = cc;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

