/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.model.impl.AttributeComplexValueModel;
import org.eclipse.higgins.idas.model.impl.AttributeSimpleValueModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.DisplayData;

public class AttributeModel
implements IAttributeModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$AttributeModel == null ? (class$org$eclipse$higgins$idas$model$impl$AttributeModel = AttributeModel.class$("org.eclipse.higgins.idas.model.impl.AttributeModel")) : class$org$eclipse$higgins$idas$model$impl$AttributeModel));
    protected URI type = null;
    protected boolean isDirect = false;
    protected IAttributeValueModel value = null;
    protected IDisplayData displayData = null;
    protected ContextModel ctx = null;
    protected OntProperty att = null;
    protected OntClass owner = null;
    protected int maxCardinality = 0;
    protected int minCardinality = 0;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$AttributeModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    protected AttributeModel(ContextModel ctx, OntProperty op, OntClass owner) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::AttributeModel");
        this.ctx = ctx;
        this.att = op;
        this.owner = owner;
        this.initialize();
    }

    protected void initialize() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::initialize");
        this.initType();
        this.initDisplayData();
        this.initValue();
    }

    protected void initType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::initType");
        if (this.type == null) {
            try {
                this.type = new URI(this.att.getURI());
                String s = this.ctx.getType().toString() + "#";
                this.isDirect = this.att.getURI().startsWith(s);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                this.type = null;
            }
        }
    }

    protected void initDisplayData() throws IdASException {
        OntClass t;
        Individual in;
        Resource r;
        RDFNode n;
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::initDisplayData");
        if (this.displayData == null && this.ctx.getP_DD() != null && this.att.hasProperty((Property)this.ctx.getP_DD()) && (n = this.att.getPropertyValue((Property)this.ctx.getP_DD())).canAs(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = AttributeModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual) && (r = (in = (Individual)n.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = AttributeModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual)).getRDFType()).canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = AttributeModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass) && (t = (OntClass)r.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = AttributeModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).equals(this.ctx.getC_DD())) {
            this.displayData = new DisplayData(this.ctx, in);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initValue() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::initValue");
        if (this.value != null) return;
        OntResource r = this.att.getRange();
        if (!r.isClass()) throw new IdASModelException("Can't determine type of attribute's value: " + this.att.getURI());
        OntClass c = r.asClass();
        if (c.hasSuperClass((Resource)this.ctx.getC_SIMP_VAL())) {
            this.value = new AttributeSimpleValueModel(this.ctx, c);
            return;
        } else {
            if (!c.hasSuperClass((Resource)this.ctx.getC_COMP_VAL())) throw new IdASModelException("Unknown type of attribute's value: " + c.getURI());
            this.value = new AttributeComplexValueModel(this.ctx, c);
        }
    }

    public URI getType() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getType");
        return this.type;
    }

    public boolean isDirect() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::isDirect");
        return this.isDirect;
    }

    public IDisplayData getDisplayData() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getDisplayData");
        return this.displayData;
    }

    public int getMaxCardinality() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getMaxCardinality");
        return this.maxCardinality;
    }

    public int getMinCardinality() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getMinCardinality");
        return this.minCardinality;
    }

    protected void initCardinality() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::initCardinality");
        ExtendedIterator itr = this.owner.listSuperClasses(true);
        while (itr.hasNext()) {
            CardinalityRestriction cr;
            Restriction r;
            OntClass c = (OntClass)itr.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty((Property)this.att)) continue;
            if (r.isCardinalityRestriction()) {
                cr = r.asCardinalityRestriction();
                this.minCardinality = cr.getCardinality();
                this.maxCardinality = cr.getCardinality();
                continue;
            }
            if (r.isMaxCardinalityRestriction()) {
                cr = r.asMaxCardinalityRestriction();
                this.maxCardinality = cr.getMaxCardinality();
                continue;
            }
            if (!r.isMinCardinalityRestriction()) continue;
            cr = r.asMinCardinalityRestriction();
            this.minCardinality = cr.getMinCardinality();
        }
    }

    public IMetadataModel getMetadataModel(URI metadataID) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getMetadataModel");
        return null;
    }

    public Iterator getMetadataModels() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getMetadataModels");
        return null;
    }

    public IAttributeValueModel getValueModel() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.AttributeModel::getValueModel");
        return this.value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

