/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.model.impl;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IDigitalSubjectModel;
import org.eclipse.higgins.idas.api.model.IDisplayData;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.model.impl.AttributeModel;
import org.eclipse.higgins.idas.model.impl.ContextModel;
import org.eclipse.higgins.idas.model.impl.DisplayData;

public class DigitalSubjectModel
implements IDigitalSubjectModel {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$idas$model$impl$DigitalSubjectModel == null ? (class$org$eclipse$higgins$idas$model$impl$DigitalSubjectModel = DigitalSubjectModel.class$("org.eclipse.higgins.idas.model.impl.DigitalSubjectModel")) : class$org$eclipse$higgins$idas$model$impl$DigitalSubjectModel));
    protected ContextModel ctx = null;
    protected OntClass ds = null;
    protected URI type = null;
    protected List attributes = null;
    protected Hashtable attMap = null;
    protected IDisplayData displayData = null;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$model$impl$DigitalSubjectModel;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    protected DigitalSubjectModel(ContextModel ctx, OntClass ds) throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::DigitalSubjectModel");
        this.ctx = ctx;
        this.ds = ds;
        this.initialize();
    }

    protected void initialize() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::initialize");
        this.initType();
        this.initAttributes();
        this.initDisplayData();
    }

    protected void initType() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::initType");
        if (this.type == null) {
            try {
                this.type = new URI(this.ds.getURI());
            }
            catch (URISyntaxException e) {
                throw new IdASModelException((Throwable)e);
            }
        }
    }

    protected void initAttributes() throws IdASException {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::initAttributes");
        this.log.debug((Object)("====== Init attributes of subject " + this.ds.getURI() + " ============================"));
        if (this.attributes == null) {
            this.attributes = new ArrayList();
            this.attMap = new Hashtable();
            ArrayList list = ModelUtils.getAttributePropertiesByDomain(this.ctx.getContext(), this.ds);
            for (int i = 0; i < list.size(); ++i) {
                OntProperty op = (OntProperty)list.get(i);
                AttributeModel m = new AttributeModel(this.ctx, op, this.ds);
                this.attributes.add(m);
                this.attMap.put(m.getType(), m);
                this.log.debug((Object)("Created attribute model for property " + op.getURI()));
            }
        }
    }

    protected void initDisplayData() throws IdASException {
        OntClass t;
        Individual in;
        Resource r;
        RDFNode n;
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::initDisplayData");
        if (this.displayData == null && this.ctx.getP_DD() != null && this.ds.hasProperty((Property)this.ctx.getP_DD()) && (n = this.ds.getPropertyValue((Property)this.ctx.getP_DD())).canAs(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = DigitalSubjectModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual) && (r = (in = (Individual)n.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = DigitalSubjectModel.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual)).getRDFType()).canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = DigitalSubjectModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass) && (t = (OntClass)r.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = DigitalSubjectModel.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)).equals(this.ctx.getC_DD())) {
            this.displayData = new DisplayData(this.ctx, in);
        }
    }

    public Iterator getAttributeModels() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getAttributeModels");
        return this.attributes.iterator();
    }

    public URI getType() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getType");
        return this.type;
    }

    public IDisplayData getDisplayData() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getDisplayData");
        return this.displayData;
    }

    public IAttributeModel getAttributeModel(URI type) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getAttributeModel");
        return (IAttributeModel)this.attMap.get(type);
    }

    public IMetadataModel getMetadataModel(URI metadataID) {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getMetadataModel");
        return null;
    }

    public Iterator getMetadataModels() {
        this.log.trace((Object)"org.eclipse.higgins.idas.model.impl.DigitalSubjectModel::getMetadataModels");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

