/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterCUIDAssertion;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.impl.Context;
import org.eclipse.higgins.idas.cp.jena2.util.HigginsVocabulary;

public class FilterCUIDAssertion extends FilterAssertion implements IFilterCUIDAssertion {
	private Log log = LogFactory.getLog(FilterCUIDAssertion.class);

	private String subjID_ = null;

	private FilterAttributeAssertion assertion_ = null;

	private Context idasContext_ = null;

	/**
	 * @param idasContext
	 */
	public FilterCUIDAssertion(Context idasContext) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::FilterCUIDAssertion");
		idasContext_ = idasContext;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IFilterCUIDAssertion#setAssertionValue(java.lang.String)
	 */
	public void setAssertionValue(String subjID) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::setAssertionValue");
		if (subjID == null)
			throw new IdASException("Unable to set \"null\" assertion value");
		subjID_ = subjID;
	}

	/**
	 * @return
	 * @throws IdASException
	 */
	public String getAssertionValue() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::getAssertionValue");
		return subjID_;
	}

	/**
	 * @return
	 * @throws IdASException
	 */
	public FilterAttributeAssertion getAttributeAssertion() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::getAttributeAssertion");
		if (subjID_ == null)
			throw new IdASException("FilterCUIDAssertion contains \"null\" assertion value");
		if (assertion_ == null) {
			assertion_ = new FilterAttributeAssertion(idasContext_);
			assertion_.setComparator(IFilterAttributeAssertion.COMP_ATTR_EQ);
			assertion_.setID(URI.create(HigginsVocabulary.uniqueIdentifier));
		}
		assertion_.setAssertionValue(idasContext_.buildSimpleAttrValue(ISimpleAttrValue.NORMALIZEDSTRING_TYPE_URI, subjID_));
		assertion_.includeSubtypes(includeSubtypes_);
		assertion_.setComparator(comparator_);
		return assertion_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#setID(java.net.URI)
	 */
	public void setID(URI id) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::setID");
		throw new IdASException("The type of FilterCUIDAssertion is predefined and couldn't be changed.");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#getCondition()
	 */
	public ICondition getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::getCondition");
		return assertion_.getCondition();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterAssertion#init(org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterContext)
	 */
	public void init(FilterContext filterContext) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.FilterCUIDAssertion::init");
		assertion_.init(filterContext);
	}

}
