/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.jena2.IContextConfiguration;

public class FileContextFactory extends AbstractContextFactory {
	private Log log = LogFactory.getLog(FileContextFactory.class);

	public FileContextFactory() throws IdASException {
		super("org.eclipse.higgins.idas.cp.jena2.file", "jena2.file");
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.FileContextFactory::FileContextFactory");
	}

	protected IContext createContext(IContextConfiguration config) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.FileContextFactory::createContext");
		return new FileContext(config);
	}

	public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.FileContextFactory::configure");
	}

	public IContext createContext(IContextId contextID) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.FileContextFactory::createContext(IContextId)");
		return new FileContext(contextID);
	}

}
