/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.cp.jena2.util.HigginsVocabulary;
import org.eclipse.higgins.idas.cp.jena2.util.ModelUtils;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.api.model.IAttributeValueModel;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class SimpleValue implements ISimpleAttrValue {
	private Log log = LogFactory.getLog(SimpleValue.class);

	protected OntProperty property_ = null;

	protected Context context_ = null;

	protected Attribute attribute_ = null;

	protected Individual container_ = null;

	protected OntClass valueClass_ = null;

	protected DatatypeProperty simpleValueProperty_ = null;

	protected IAttributeSimpleValueModel valueModel_ = null;

	protected Individual owner_ = null;

	protected XMLValue value_ = null;

	protected URI type_ = null;

	protected URI xmlType_ = null;

	// the subject which owns this complex value (through any level of
	// attribute/complex value)
	protected DigitalSubject subject_ = null;

	public SimpleValue(Context context, Attribute attribute, Individual container, OntProperty attributeProperty) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::SimpleValue");
		if (context == null)
			throw new IdASException("Parameter \"context\" is null.");
		if (attribute == null)
			throw new IdASException("Parameter \"attribute\" is null.");
		if (container == null)
			throw new IdASException("Parameter \"container\" is null.");
		context_ = context;
		attribute_ = attribute;
		container_ = container;
		subject_ = attribute.getSubjectOwner();
		owner_ = attribute.getOwner();
		valueClass_ = context_.getOntClass(container_.getRDFType().getURI());
		property_ = attributeProperty;
		simpleValueProperty_ = ModelUtils.getSimpleValuePropertyByDomain(context_, valueClass_);
		if (simpleValueProperty_ == null)
			throw new IdASException("Can not found simple value datatype property for class " + valueClass_.getURI());
		OntClass svClass = context_.getOntClass(HigginsVocabulary.SimpleValue);
		ModelUtils.isClassRelative(svClass, valueClass_);
		IAttributeModel attrModel = attribute_.getModel();
		if (attrModel != null) {
			IAttributeValueModel valueModel = attrModel.getValueModel();
			if (valueModel instanceof IAttributeSimpleValueModel)
				valueModel_ = (IAttributeSimpleValueModel) valueModel;
		}
		value_ = new XMLValue(context_, container_, simpleValueProperty_);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#getCanonical()
	 */
	public String getCanonical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getCanonical");
		return value_.getCanonical();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#getData()
	 */
	public Object getData() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getData");
		return value_.getData();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#getLexical()
	 */
	public String getLexical() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getLexical");
		return value_.getLexical();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#setData(java.lang.Object)
	 */
	public void setData(Object data) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::setData");
		value_.setData(data);
		context_.registerChangedSubject(subject_);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.ITypedValue#getType()
	 */
	public URI getType() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getType");
		if (xmlType_ == null)
			xmlType_ = value_.getXmlType();
		return type_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IAttributeValue#isSimple()
	 */
	public boolean isSimple() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::isSimple");
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IAttributeValue#remove()
	 */
	public void remove() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::remove");
		context_.registerChangedSubject(subject_);
		owner_.removeProperty(property_, container_);
		ModelUtils.removeIndividual(context_, container_);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IHasMetadata#addMetadata(java.net.URI)
	 */
	public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::addMetadata");
		if (metadataID == null)
			throw new IdASException("Parameter \"metadataID\" is null.");
		IMetadata newMetadata = getMetadata(metadataID);
		return newMetadata;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IHasMetadata#addMetadata(org.eclipse.higgins.idas.api.IMetadata)
	 */
	public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::addMetadata");
		if (copyFrom == null)
			throw new IdASException("Parameter \"copyFrom\" is null.");
		IMetadata newMetadata = getMetadata(copyFrom.getID());
		newMetadata.setData(copyFrom.getData());
		context_.registerChangedSubject(subject_);
		return newMetadata;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IHasMetadata#getMetadata(java.net.URI)
	 */
	public IMetadata getMetadata(URI metadataID) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getMetadata");
		if (metadataID == null)
			throw new IdASException("Parameter \"metadataID\" is null.");
		String uri = metadataID.toString();
		DatatypeProperty prop = context_.getDatatypeProperty(uri);
		if (prop == null)
			throw new IdASException("Can not find datatype property with URI " + uri);
		DatatypeProperty metadata = context_.getDatatypeProperty(HigginsVocabulary.metadata);
		if (metadata == null)
			throw new IdASException("Can not find datatype property with URI " + HigginsVocabulary.metadata);
		if (ModelUtils.isPropertyRelative(metadata, prop) == false)
			throw new IdASException("Property with URI " + uri + " is not a subproperty of " + HigginsVocabulary.metadata);
		if (ModelUtils.isPropertyOfClass(context_, valueClass_, prop) == false)
			throw new IdASException("Can not add metadata with type " + uri + " for class " + valueClass_.getURI());
		return new Metadata(context_, container_, prop, subject_);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.api.IHasMetadata#getMetadataSet()
	 */
	public Iterator getMetadataSet() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getMetadataSet");
		ArrayList list = new ArrayList();
		DatatypeProperty metadata = context_.getDatatypeProperty(HigginsVocabulary.metadata);
		if (metadata == null)
			throw new IdASException("Can not find datatype property with URI " + HigginsVocabulary.metadata);
		StmtIterator props = container_.listProperties();
		while (props.hasNext()) {
			Statement st = props.nextStatement();
			Property prop = st.getPredicate();
			DatatypeProperty dpProperty = context_.getModel().getDatatypeProperty(prop.getURI());
			if (dpProperty != null) {
				if (ModelUtils.isPropertyRelative(metadata, dpProperty)) {
					IMetadata md = new Metadata(context_, container_, dpProperty, subject_);
					list.add(md);
				}
			}
		}
		return list.iterator();
	}

	/**
	 * @return
	 * @throws IdASException
	 */
	public Individual getContainer() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.SimpleValue::getContainer");
		return container_;
	}

	public boolean equals(IAttributeValue value) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean equals(IHasMetadata metadataSet) throws IdASException {
		// TODO Auto-generated method stub
		return false;
	}

}
