/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.impl.filter;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;

public class CompoundCondition implements ICondition {
	private Log log = LogFactory.getLog(CompoundCondition.class);

	private String operator_;

	private int level_;

	private ArrayList conditions_ = new ArrayList();

	public CompoundCondition(String operator) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::CompoundCondition");
		operator_ = operator;
	}

	/**
	 * @param condition
	 */
	public void addCondition(ICondition condition) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::addCondition");
		conditions_.add(condition);
	}

	/**
	 * @param operator
	 */
	public void setOperator(String operator) {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::setOperator");
		operator_ = operator;
	}

	/**
	 * @param buf
	 * @throws IdASException
	 */
	private void addNOTCondition(StringBuffer buf) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::addNOTCondition");
		int size = conditions_.size();
		if (size != 1)
			throw new IdASException("Wrong subconditions count = " + size + ", expected count = 1");
		ICondition cnd = (ICondition) conditions_.get(0);
		cnd.setLevel(level_ + 1);
		buf.append("(");
		buf.append(cnd.getCondition());
		buf.append(") = false");
	}

	/**
	 * @param buf
	 * @param oper
	 * @throws IdASException
	 */
	private void addCondition(StringBuffer buf, String oper) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::addCondition(StringBuffer, String)");
		int size = conditions_.size();
		for (int i = 0; i < size; i++) {
			if (i > 0)
				buf.append(oper);
			ICondition cnd = (ICondition) conditions_.get(i);
			cnd.setLevel(level_ + 1);
			buf.append(cnd.getCondition());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition#getCondition()
	 */
	public StringBuffer getCondition() throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::getCondition");
		int size = conditions_.size();
		StringBuffer buf = new StringBuffer();
		if (level_ == 0 || size > 1)
			buf.append("(");
		String oper = null;
		if (Filter.OP_NOT.equals(operator_)) {
			addNOTCondition(buf);
		}
		else if (Filter.OP_AND.equals(operator_)) {
			oper = " && ";
			addCondition(buf, oper);
		} 
		else if (Filter.OP_OR.equals(operator_)) {
			oper = " || ";
			addCondition(buf, oper);
		}
		else 
			throw new IdASException("Undefined filter operator.");
		if (level_ == 0 || size > 1)
			buf.append(")");
		return buf;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.idas.cp.jena2.impl.filter.ICondition#setLevel(int)
	 */
	public void setLevel(int level) throws IdASException {
		log.trace("org.eclipse.higgins.idas.cp.jena2.impl.filter.CompoundCondition::setLevel");
		level_ = level;
	}

}
