/**
 * Copyright (c) 2006 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.idas.cp.jena2.util;

import java.net.URI;

/**
 * Vocabulary definitions from Higgins Ontology v 1.11
 */
public class HigginsVocabulary {

	public static final String NAME_SPACE = "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#";

	
	
	public static final String ContextObject = NAME_SPACE + "ContextObject";
	public static final URI ContextObjectURI = URI.create(ContextObject);
	public static final String DigitalSubject = NAME_SPACE + "DigitalSubject";
	public static final URI DigitalSubjectURI = URI.create(DigitalSubject);
	public static final String SubjectRelationship = NAME_SPACE + "SubjectRelationship";
	public static final URI SubjectRelationshipURI = URI.create(SubjectRelationship);
	public static final String Value = NAME_SPACE + "Value";
	public static final URI ValueURI = URI.create(Value);
	public static final String ComplexValue = NAME_SPACE + "ComplexValue";
	public static final URI ComplexValueURI = URI.create(ComplexValue);
	public static final String SimpleValue = NAME_SPACE + "SimpleValue";
	public static final URI SimpleValueURI = URI.create(SimpleValue);
	public static final String simpleValue = NAME_SPACE + "simpleValue";
	public static final URI simpleValueURI = URI.create(simpleValue);
	public static final String metadata = NAME_SPACE + "simpleMetadata";
	public static final URI metadataURI = URI.create(metadata);
	public static final String uniqueIdentifier = NAME_SPACE + "uniqueIdentifier";
	public static final URI uniqueIdentifierURI = URI.create(uniqueIdentifier);
	public static final String attribute = NAME_SPACE + "attribute";
	public static final URI attributeURI = URI.create(attribute);
	public static final String Attribute = NAME_SPACE + "Attribute";
	public static final URI AttributeURI = URI.create(Attribute);

	public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema#";

}



/*
	public static final String attribute = NAME_SPACE + "attribute";
	public static final String timeSpan = NAME_SPACE + "timeSpan";
	public static final String source = NAME_SPACE + "source";
	public static final String uniqueIdentifier = NAME_SPACE + "uniqueIdentifier";
	public static final String contextRelationship = NAME_SPACE + "contextRelationship";
	public static final String lastVerifiedFromSource = NAME_SPACE + "lastVerifiedFromSource";
	public static final String subjectCUID = NAME_SPACE + "subjectCUID";
	public static final String stringSimpleValue = NAME_SPACE + "string";
	public static final String validTo = NAME_SPACE + "validTo";
	public static final String simpleMetadata = NAME_SPACE + "simpleMetadata";
	public static final String normalizedStringSimpleValue = NAME_SPACE + "normalizedString";
	public static final String integerSimpleValue = NAME_SPACE + "integer";
	public static final String identifier = NAME_SPACE + "identifier";
	public static final String lastVerifyAttempt = NAME_SPACE + "lastVerifyAttempt";
	public static final String syncConflict = NAME_SPACE + "syncConflict";
	public static final String simpleValue = NAME_SPACE + "simpleValue";
	public static final String base64BinarySimpleValue = NAME_SPACE + "base64Binary";
	public static final String lastModified = NAME_SPACE + "lastModified";
	public static final String contextURI = NAME_SPACE + "contextURI";
	public static final String validFrom = NAME_SPACE + "validFrom";
	public static final String SubjectRelationship = NAME_SPACE + "SubjectRelationship";
	public static final String TimeSpan = NAME_SPACE + "TimeSpan";
	public static final String ContextRelationship = NAME_SPACE + "ContextRelationship";
	public static final String ContextObject = NAME_SPACE + "ContextObject";
	public static final String NormalizedStringSimpleAttribute = NAME_SPACE + "NormalizedString";
	public static final String Base64BinarySimpleAttribute = NAME_SPACE + "Base64Binary";
	public static final String Attribute = NAME_SPACE + "Attribute";
	public static final String StringSimpleAttribute = NAME_SPACE + "String";
	public static final String IntegerSimpleAttribute = NAME_SPACE + "Integer";
	public static final String DigitalSubject = NAME_SPACE + "DigitalSubject";
	public static final String ComplexAttribute = NAME_SPACE + "ComplexAttribute";
	public static final String SimpleAttribute = NAME_SPACE + "SimpleAttribute";

*/