/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.Arg;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgProc;
import arq.cmdline.CommandLineBase;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CmdLineArgs
extends CommandLineBase {
    private boolean processedArgs = false;
    protected Map argMap = new HashMap();
    protected Map args = new HashMap();
    protected List positionals = new ArrayList();
    static final String DefaultIndirectMarker = "@";

    public CmdLineArgs(String[] stringArray) {
        super(stringArray);
    }

    public void process() throws IllegalArgumentException {
        this.processedArgs = true;
        this.apply(new ArgProcessor());
    }

    public CmdLineArgs add(String string, boolean bl) {
        return this.add(new ArgDecl(bl, string));
    }

    public CmdLineArgs add(boolean bl, String string) {
        return this.add(new ArgDecl(bl, string));
    }

    public CmdLineArgs add(ArgDecl argDecl) {
        Iterator iterator = argDecl.names();
        while (iterator.hasNext()) {
            this.argMap.put(iterator.next(), argDecl);
        }
        return this;
    }

    public boolean matchesIndirect(String string) {
        return this.matchesIndirect(string, DefaultIndirectMarker);
    }

    public boolean matchesIndirect(String string, String string2) {
        return string.startsWith(string2);
    }

    public String indirect(String string) {
        return this.indirect(string, DefaultIndirectMarker);
    }

    public String indirect(String string, String string2) {
        if (!this.matchesIndirect(string, string2)) {
            return string;
        }
        string = string.substring(string2.length());
        string = FileManager.get().readWholeFileAsUTF8(string);
        return string;
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasArg(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iterator = this.args.values().iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!argDecl.matches(arg2)) continue;
            arg = arg2;
        }
        return arg;
    }

    public Arg getArg(String string) {
        string = ArgDecl.canonicalForm(string);
        return (Arg)this.args.get(string);
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String string) {
        Arg arg = this.getArg(string);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    public List getValues(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public List getValues(String string) {
        Arg arg = this.getArg(string);
        if (arg == null) {
            return null;
        }
        return arg.getValues();
    }

    public String getPositionalArg(int n) {
        return (String)this.positionals.get(n);
    }

    public int getNumPositional() {
        return this.positionals.size();
    }

    public boolean hasPositional() {
        return this.positionals.size() > 0;
    }

    public List getPositional() {
        return this.positionals;
    }

    protected void handleUnrecognizedArg(String string) {
        throw new IllegalArgumentException("Unknown argument: " + string);
    }

    private ArgDecl find(String string) {
        string = ArgDecl.canonicalForm(string);
        return (ArgDecl)this.argMap.get(string);
    }

    public String toString() {
        String string;
        if (!this.processedArgs) {
            return super.toString();
        }
        String string2 = "";
        String string3 = "";
        Iterator<Object> iterator = this.args.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Arg arg = (Arg)this.args.get(string);
            string2 = string2 + string3 + arg;
            string3 = " ";
        }
        string3 = " -- ";
        iterator = this.positionals.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = string2 + string3 + string;
            string3 = " ";
        }
        return string2;
    }

    class ArgProcessor
    implements ArgProc {
        boolean nextArgProcessed = false;
        boolean positionalArgsStarted = false;

        ArgProcessor() {
        }

        public void startArgs() {
            this.nextArgProcessed = false;
            this.positionalArgsStarted = false;
        }

        public void finishArgs() {
        }

        public void arg(String string, int n) {
            if (this.nextArgProcessed) {
                this.nextArgProcessed = false;
                return;
            }
            if (this.positionalArgsStarted) {
                CmdLineArgs.this.positionals.add(string);
                return;
            }
            if (string.equals("-") || string.equals("--")) {
                this.positionalArgsStarted = true;
                return;
            }
            if (!string.startsWith("-")) {
                this.positionalArgsStarted = true;
                CmdLineArgs.this.positionals.add(string);
                return;
            }
            if (!CmdLineArgs.this.argMap.containsKey(string = ArgDecl.canonicalForm(string))) {
                CmdLineArgs.this.handleUnrecognizedArg(string);
                return;
            }
            if (!CmdLineArgs.this.args.containsKey(string)) {
                CmdLineArgs.this.args.put(string, new Arg(string));
            }
            Arg arg = (Arg)CmdLineArgs.this.args.get(string);
            ArgDecl argDecl = (ArgDecl)CmdLineArgs.this.argMap.get(string);
            if (argDecl.takesValue()) {
                String string2 = CmdLineArgs.this.getArg(n + 1);
                if (string2 == null) {
                    throw new IllegalArgumentException("No value for argument: " + arg.getName());
                }
                arg.setValue(string2);
                arg.addValue(string2);
                this.nextArgProcessed = true;
            }
        }
    }
}

