/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.ResultsFormat;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.PlainFormat;
import com.hp.hpl.jena.query.resultset.ResultSetApply;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;
import jena.cmdline.ArgDecl;
import jena.util.DBcmd;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class dbquery
extends DBcmd {
    private static Log log = LogFactory.getLog((Class)dbquery.class);
    public static final String[] usage = new String[]{"dbquery [--spec spec] | [db_description] [--model name] --query QueryFile", "  where db_description is", "    --db JDBC URL --dbType type", "    --dbUser user --dbPassword password"};
    private ArgDecl queryDecl = new ArgDecl(true, "query");

    public static void main(String[] stringArray) {
        dbquery dbquery2 = new dbquery();
        dbquery2.setUsage(usage);
        dbquery2.init(stringArray);
        dbquery2.exec();
    }

    public dbquery() {
        super("dbquery", false);
        this.getCommandLine().add(this.queryDecl);
    }

    protected void exec0() {
        if (!this.getCommandLine().contains(this.queryDecl)) {
            System.err.println("No query");
            return;
        }
        String string = this.getCommandLine().getValue(this.queryDecl);
        String string2 = FileManager.get().readWholeFileAsUTF8(string);
        this.exec1(string2);
    }

    protected boolean exec1(String string) {
        if (string.startsWith("@")) {
            string = FileManager.get().readWholeFileAsUTF8(string.substring(1));
        }
        Query query2 = QueryFactory.create(string);
        QueryExecution queryExecution = QueryExecutionFactory.create(query2, (Model)super.getRDBModel());
        this.doQuery(query2, queryExecution, ResultsFormat.FMT_TEXT);
        queryExecution.close();
        return false;
    }

    public void doQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        if (query2.isSelectType()) {
            this.doSelectQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isDescribeType()) {
            this.doDescribeQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isConstructType()) {
            this.doConstructQuery(query2, queryExecution, resultsFormat);
        }
        if (query2.isAskType()) {
            this.doAskQuery(query2, queryExecution, resultsFormat);
        }
        queryExecution.close();
    }

    void doSelectQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Object object;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.makeRewindable(resultSet);
        boolean bl = false;
        if (resultsFormat.equals(ResultsFormat.FMT_NONE) || resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
            int n = ResultSetFormatter.consume(resultSet);
            if (resultsFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + n);
            }
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_RDF) || resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            Model model = ResultSetFormatter.toModel(resultSet);
            model.setNsPrefixes(query2.getPrefixMapping());
            object = model.getWriter("TURTLE");
            model.setNsPrefix("rs", ResultSetVocab.getURI());
            object.write(model, (OutputStream)System.out, null);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, resultSet);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RS_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet, query2);
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet, query2.getPrefixMapping());
            bl = true;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TUPLES)) {
            PlainFormat plainFormat = new PlainFormat((OutputStream)System.out, query2.getPrefixMapping());
            object = new ResultSetApply(resultSet, plainFormat);
            ((ResultSetApply)object).apply();
            bl = true;
        }
        if (!bl) {
            log.warn((Object)("Unknown format request: " + resultsFormat));
        }
        System.out.flush();
    }

    void doDescribeQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execDescribe();
        this.writeModel(query2, model, resultsFormat);
    }

    void doConstructQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        Model model = queryExecution.execConstruct();
        this.writeModel(query2, model, resultsFormat);
    }

    void writeModel(Query query2, Model model, ResultsFormat resultsFormat) {
        if (resultsFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            String string = "";
            if (query2.isDescribeType()) {
                string = "DESCRIBE";
            }
            if (query2.isConstructType()) {
                string = "CONSTRUCT";
            }
            System.out.println("# ======== " + string + " results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("# ======== ");
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write((OutputStream)System.out, "N3", null);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + resultsFormat.getSymbol());
    }

    void doAskQuery(Query query2, QueryExecution queryExecution, ResultsFormat resultsFormat) {
        boolean bl = queryExecution.execAsk();
        if (resultsFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, bl);
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_RDF_N3) || resultsFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            ResultSetFormatter.outputAsRDF((OutputStream)System.out, "TURTLE", bl);
            System.out.flush();
            return;
        }
        if (resultsFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
            return;
        }
        System.err.println("Unknown format: " + resultsFormat.getSymbol());
    }
}

