/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmd.QCmd;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.QueryEngineAccess;
import com.hp.hpl.jena.query.serializer.FmtElementARQ;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class qparse {
    static String usage;

    public static void main(String[] stringArray) {
        Object object;
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        cmdLineArgs.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        cmdLineArgs.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        cmdLineArgs.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        cmdLineArgs.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        cmdLineArgs.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "file", "query");
        cmdLineArgs.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "num");
        cmdLineArgs.add(argDecl7);
        ArgDecl argDecl8 = new ArgDecl(false, "plain");
        cmdLineArgs.add(argDecl8);
        ArgDecl argDecl9 = new ArgDecl(false, "n", "parse");
        cmdLineArgs.add(argDecl9);
        ArgDecl argDecl10 = new ArgDecl(true, "planning");
        cmdLineArgs.add(argDecl10);
        ArgDecl argDecl11 = new ArgDecl(true, "show");
        cmdLineArgs.add(argDecl11);
        ArgDecl argDecl12 = new ArgDecl(true, "base");
        cmdLineArgs.add(argDecl12);
        ArgDecl argDecl13 = new ArgDecl(false, "ver", "version", "V");
        cmdLineArgs.add(argDecl13);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        QCmd qCmd = new QCmd();
        try {
            cmdLineArgs.process();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (cmdLineArgs.contains(argDecl2)) {
            qparse.usage();
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl13)) {
            System.out.println("ARQ Version: 1.3 (Jena: 2.4-dev)");
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl10)) {
            object = cmdLineArgs.getValue(argDecl10);
            if (((String)object).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("yes")) {
                ARQ.getContext().set(ARQ.orderPlanning, "true");
            } else if (((String)object).equalsIgnoreCase("off") || ((String)object).equalsIgnoreCase("no")) {
                ARQ.getContext().set(ARQ.orderPlanning, "false");
            } else {
                System.err.println("Unrecognized planning control: " + (String)object);
                System.exit(3);
            }
        }
        if (cmdLineArgs.contains(argDecl11)) {
            object = cmdLineArgs.getValues(argDecl11);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equalsIgnoreCase("plan")) {
                    bl3 = true;
                }
                if (!string.equalsIgnoreCase("query")) continue;
                bl2 = true;
            }
        }
        if (cmdLineArgs.contains(argDecl12)) {
            qCmd.setBaseURI(cmdLineArgs.getValue(argDecl12));
            RelURI.setBaseURI(qCmd.getBaseURI());
        }
        if (cmdLineArgs.contains(argDecl4)) {
            object = Syntax.lookup(cmdLineArgs.getValue(argDecl4));
            if (object == null) {
                qparse.msg("Unknown query syntax for input: " + cmdLineArgs.getArg(argDecl4).getValue());
                qparse.writeSyntaxes("Known syntaxes (not all implemented for both input and output)", System.err);
                System.exit(9);
            }
            qCmd.setInSyntax((Syntax)object);
        }
        if (cmdLineArgs.contains(argDecl5)) {
            object = Syntax.lookup(cmdLineArgs.getValue(argDecl5));
            if (object == null) {
                qparse.msg("Unknown query syntax for output: " + cmdLineArgs.getArg(argDecl5).getValue());
                qparse.writeSyntaxes("Known syntaxes", System.err);
                System.exit(9);
            }
            qCmd.setOutSyntax((Syntax)object);
        }
        qCmd.setLineNumbers(true);
        if (cmdLineArgs.contains(argDecl7)) {
            boolean bl4 = cmdLineArgs.getValue(argDecl7).equalsIgnoreCase("yes");
            qCmd.setLineNumbers(bl4);
        }
        if (cmdLineArgs.contains(argDecl8)) {
            FmtElementARQ.PRETTY_PRINT = false;
        }
        if (cmdLineArgs.contains(argDecl8)) {
            qCmd.setLineNumbers(false);
        }
        if (cmdLineArgs.contains(argDecl9)) {
            bl = false;
        }
        if (cmdLineArgs.contains(argDecl6)) {
            if (cmdLineArgs.hasPositional()) {
                System.err.println("file argument and command line item");
                System.exit(9);
            }
            qCmd.setQueryFilename(cmdLineArgs.getValue(argDecl6));
        } else if (!cmdLineArgs.hasPositional()) {
            try {
                qCmd.setQueryString(FileUtils.readWholeFileAsUTF8((InputStream)System.in));
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace(System.err);
            }
        } else {
            String string;
            if (cmdLineArgs.hasPositional() && cmdLineArgs.getNumPositional() != 1) {
                System.err.println("Too many command line items");
                System.exit(9);
            }
            if (cmdLineArgs.matchesIndirect(string = cmdLineArgs.getPositionalArg(0))) {
                qCmd.setSyntaxHint(string);
            }
            string = cmdLineArgs.indirect(string);
            qCmd.setQueryString(string);
        }
        if (qCmd.getOutSyntax() == null) {
            qCmd.setOutSyntax(Syntax.syntaxSPARQL);
        }
        qparse.process(qCmd, bl, bl2, bl3);
    }

    static void process(QCmd qCmd, boolean bl, boolean bl2, boolean bl3) {
        qCmd.parseQuery();
        if (qCmd.getQuery() == null) {
            return;
        }
        if (bl2) {
            qCmd.getQuery().serialize(System.out, Syntax.syntaxAbstract);
            System.out.println();
        }
        if (bl3) {
            QueryEngineAccess queryEngineAccess = new QueryEngineAccess(qCmd.getQuery());
            Plan plan = new Plan();
            queryEngineAccess.forcePlanning(plan);
            PlanFormatter.out((OutputStream)System.out, qCmd.getQuery(), plan.getRoot());
            System.out.println();
        }
        if (bl) {
            qCmd.printQuery();
        }
        qCmd.checkParse();
    }

    static void writeSyntaxes(String string, PrintStream printStream) {
        if (string != null) {
            printStream.println(string);
        }
        Iterator iterator = Syntax.querySyntaxNames.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Syntax syntax = Syntax.lookup(string2);
            string2 = qparse.padOut(string2, 10);
            printStream.println("  " + string2 + "  " + syntax);
        }
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static String padOut(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i <= n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static void usage() {
        qparse.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        usage = qparse.class.getName() + " [--in syntax] [--out syntax] [\"query\" | --query <file>\n" + "  where syntax is one of ARQ, SPARQL, RDQL\n" + "Other options: \n" + "  --num on|off   Line number ('on' by default)\n" + "  --base URI     Set the base URI for resolving relative URIs\n" + "  --plain        No pretty printing\n" + "  -n, --parse    Parse only - don't print\n" + "  ---planning    Turn planning on/off\n" + "  --show X       Show internal structure (X = query or plan)\n";
    }
}

