/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.query.expr.E_Function;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.junit.QueryTestSuiteFactory;
import com.hp.hpl.jena.query.junit.SimpleTestRunner;
import com.hp.hpl.jena.query.test.ARQTestSuite;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.Utils;
import java.io.File;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class qtest {
    static String className;
    static String usage;

    public static void main(String[] stringArray) {
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        cmdLineArgs.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "all");
        cmdLineArgs.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "wg", "dawg");
        cmdLineArgs.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "dir");
        cmdLineArgs.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(true, "query");
        cmdLineArgs.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "data");
        cmdLineArgs.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "result");
        cmdLineArgs.add(argDecl7);
        try {
            cmdLineArgs.process();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            qtest.usage(System.err);
            System.exit(2);
        }
        if (cmdLineArgs.contains(argDecl) || !cmdLineArgs.hasArgs() && !cmdLineArgs.hasPositional()) {
            qtest.usage();
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl5) || cmdLineArgs.contains(argDecl6) || cmdLineArgs.contains(argDecl7)) {
            if (!(cmdLineArgs.contains(argDecl5) && cmdLineArgs.contains(argDecl6) && cmdLineArgs.contains(argDecl7))) {
                qtest.argError("Must give query, data and result to run a single test");
            }
            String string = cmdLineArgs.getValue(argDecl5);
            String string2 = cmdLineArgs.getValue(argDecl6);
            String string3 = cmdLineArgs.getValue(argDecl7);
            TestSuite testSuite = QueryTestSuiteFactory.make(string, string2, string3);
            SimpleTestRunner.runAndReport((Test)testSuite);
            return;
        }
        if (cmdLineArgs.contains(argDecl2)) {
            qtest.allTests();
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl3)) {
            qtest.dawgTests();
            System.exit(0);
        }
        if (!cmdLineArgs.hasPositional()) {
            qtest.argError("No manifest file");
        }
        String string = cmdLineArgs.getPositionalArg(0);
        String string4 = RelURI.resolve(string);
        NodeValue.VerboseWarnings = false;
        E_Function.WarnOnUnknownFunction = false;
        qtest.oneManifest(string4);
        System.exit(0);
    }

    static void oneManifest(String string) {
        TestSuite testSuite = QueryTestSuiteFactory.make(string);
        SimpleTestRunner.runAndReport((Test)testSuite);
    }

    static void allTests() {
        qtest.ensureDirExists("testing");
        qtest.ensureDirExists("testing/ARQ");
        qtest.ensureDirExists("testing/DAWG");
        qtest.ensureDirExists("testing/DAWG-Approved");
        TestSuite testSuite = ARQTestSuite.suite();
        TestRunner.run((Test)testSuite);
        System.exit(0);
    }

    static void dawgTests() {
        System.err.println("DAWG tests not packaged up yet");
        System.exit(4);
    }

    static void usage() {
        qtest.usage(System.err);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static void ensureDirExists(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            System.err.println("Can't find required directory: '" + string + "'");
            System.exit(8);
        }
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        className = Utils.classShortName(qtest.class);
        usage = "One of:\n  " + className + " [--all]\n" + "  " + className + " [--dawg]\n" + "  " + className + " manifest\n" + "  " + className + " --query queryFile --data dataFile --result resultsFile\n" + "     where --all      run all built-in tests\n" + "           --dawg     run working group tests\n" + "           manifest   run a set of tests";
    }
}

