/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmd.QCmd;
import arq.cmd.ResultsFormat;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DataFormat;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.QueryEngineAccess;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class query {
    static Syntax defaultSyntax;
    protected static Log log;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            query.usage();
            System.exit(0);
        }
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        cmdLineArgs.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "v", "verbose");
        cmdLineArgs.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "ver", "version", "V");
        cmdLineArgs.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(false, "q", "quiet");
        cmdLineArgs.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(false, "n", "noExec", "noexec");
        cmdLineArgs.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "graph", "data");
        cmdLineArgs.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "named", "namedgraph", "namedGraph");
        cmdLineArgs.add(argDecl7);
        ArgDecl argDecl8 = new ArgDecl(true, "service");
        cmdLineArgs.add(argDecl8);
        ArgDecl argDecl9 = new ArgDecl(false, "post", "POST");
        cmdLineArgs.add(argDecl9);
        ArgDecl argDecl10 = new ArgDecl(true, "query", "file");
        cmdLineArgs.add(argDecl10);
        ArgDecl argDecl11 = new ArgDecl(true, "syntax", "syn", "in");
        cmdLineArgs.add(argDecl11);
        ArgDecl argDecl12 = new ArgDecl(true, "fmt", "format");
        cmdLineArgs.add(argDecl12);
        ArgDecl argDecl13 = new ArgDecl(true, "results", "rfmt");
        cmdLineArgs.add(argDecl13);
        ArgDecl argDecl14 = new ArgDecl(true, "planning");
        cmdLineArgs.add(argDecl14);
        ArgDecl argDecl15 = new ArgDecl(true, "show");
        cmdLineArgs.add(argDecl15);
        ArgDecl argDecl16 = new ArgDecl(true, "dir");
        cmdLineArgs.add(argDecl16);
        ArgDecl argDecl17 = new ArgDecl(true, "base");
        cmdLineArgs.add(argDecl17);
        ArgDecl argDecl18 = new ArgDecl(true, "lmap");
        cmdLineArgs.add(argDecl18);
        try {
            cmdLineArgs.process();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            query.usage(System.err);
            System.exit(2);
        }
        if (cmdLineArgs.contains(argDecl)) {
            query.usage();
            System.exit(0);
        }
        if (cmdLineArgs.contains(argDecl3)) {
            System.out.println("ARQ Version: 1.3 (Jena: 2.4-dev)");
            System.exit(0);
        }
        QCmd qCmd = new QCmd();
        boolean bl4 = cmdLineArgs.contains(argDecl2);
        if (bl4) {
            qCmd.setMessageLevel(qCmd.getMessageLevel() + 1);
        }
        if (bl = cmdLineArgs.contains(argDecl4)) {
            qCmd.setMessageLevel(qCmd.getMessageLevel() - 1);
        }
        boolean bl5 = true;
        if (cmdLineArgs.contains(argDecl5)) {
            bl5 = false;
        }
        if (cmdLineArgs.contains(argDecl16)) {
            object3 = cmdLineArgs.getValue(argDecl16);
            qCmd.setFileManager(new FileManager());
            qCmd.getFileManager().addLocatorFile((String)object3);
            qCmd.getFileManager().addLocatorURL();
        } else {
            qCmd.setFileManager(FileManager.get());
        }
        if (cmdLineArgs.contains(argDecl17)) {
            qCmd.setBaseURI(cmdLineArgs.getValue(argDecl17));
            RelURI.setBaseURI(qCmd.getBaseURI());
        }
        if (cmdLineArgs.contains(argDecl18)) {
            object3 = cmdLineArgs.getValue(argDecl18);
            object2 = new LocationMapper((String)object3);
            qCmd.getFileManager().setLocationMapper((LocationMapper)object2);
        }
        if (cmdLineArgs.contains(argDecl14)) {
            object3 = cmdLineArgs.getValue(argDecl14);
            if (((String)object3).equalsIgnoreCase("on") || ((String)object3).equalsIgnoreCase("yes")) {
                ARQ.getContext().set(ARQ.orderPlanning, "true");
            } else if (((String)object3).equalsIgnoreCase("off") || ((String)object3).equalsIgnoreCase("no")) {
                ARQ.getContext().set(ARQ.orderPlanning, "false");
            } else {
                query.argError("Unrecognized planning control: " + (String)object3);
            }
        }
        if (cmdLineArgs.contains(argDecl15)) {
            object3 = cmdLineArgs.getValues(argDecl15);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equalsIgnoreCase("plan")) {
                    bl3 = true;
                }
                if (!((String)object).equalsIgnoreCase("query")) continue;
                bl2 = true;
            }
        }
        if (cmdLineArgs.contains(argDecl8)) {
            object3 = cmdLineArgs.getValue(argDecl8);
            qCmd.setServiceURL((String)object3);
        }
        if (cmdLineArgs.contains(argDecl9)) {
            qCmd.setForcePost(true);
        }
        qCmd.setDefaultSyntax(defaultSyntax);
        if (cmdLineArgs.contains(argDecl11)) {
            object3 = cmdLineArgs.getValue(argDecl11);
            object2 = Syntax.lookup((String)object3);
            if (object2 == null) {
                query.argError("Unrecognized syntax: " + object2);
            }
            qCmd.setInSyntax((Syntax)object2);
        }
        object3 = cmdLineArgs.getValue(argDecl10);
        if (cmdLineArgs.getNumPositional() == 0 && object3 == null) {
            query.argError("No query string or query file");
        }
        if (cmdLineArgs.getNumPositional() > 1) {
            query.argError("Only one query string allowed");
        }
        if (cmdLineArgs.getNumPositional() == 1 && object3 != null) {
            query.argError("Either query string or query file - not both");
        }
        if (object3 != null) {
            qCmd.setQueryFilename((String)object3);
        } else {
            object2 = cmdLineArgs.getPositionalArg(0);
            if (cmdLineArgs.matchesIndirect((String)object2)) {
                qCmd.setSyntaxHint((String)object2);
            }
            object2 = cmdLineArgs.indirect((String)object2);
            qCmd.setQueryString((String)object2);
        }
        if (cmdLineArgs.contains(argDecl6)) {
            qCmd.setGraphURLs(cmdLineArgs.getValues(argDecl6));
        }
        if (cmdLineArgs.contains(argDecl12)) {
            object2 = cmdLineArgs.getValue(argDecl12);
            qCmd.setDataSyntax(DataFormat.lookup((String)object2));
            if (qCmd.getDataSyntax() == null) {
                query.argError("Unrecognized syntax for data: " + (String)object2);
            }
        }
        if (cmdLineArgs.contains(argDecl7)) {
            qCmd.setNamedGraphURLs(cmdLineArgs.getValues(argDecl7));
        }
        if (cmdLineArgs.contains(argDecl13)) {
            object2 = cmdLineArgs.getValue(argDecl13);
            qCmd.setOutputFormat(ResultsFormat.lookup((String)object2));
            if (qCmd.getOutputFormat() == null) {
                query.argError("Unrecognized output format: " + (String)object2);
            }
        }
        try {
            qCmd.setLineNumbers(true);
            qCmd.parseQuery();
            if (qCmd.getQuery() == null) {
                return;
            }
            if (qCmd.getMessageLevel() > 0) {
                qCmd.printQuery();
                System.out.println();
            }
            if (bl2) {
                qCmd.getQuery().serialize(System.out, Syntax.syntaxAbstract);
                System.out.println();
            }
            if (bl3) {
                object2 = new QueryEngineAccess(qCmd.getQuery());
                object = new Plan();
                ((QueryEngineAccess)object2).forcePlanning((Plan)object);
                PlanFormatter.out((OutputStream)System.out, qCmd.getQuery(), ((Plan)object).getRoot());
                System.out.println();
            }
            if (bl5) {
                qCmd.query();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception from QCmd: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(9);
        }
    }

    static void usage() {
        query.usage(System.out);
    }

    static void usage(PrintStream printStream) {
        printStream.println("Usage: [--data URL] [queryString | --query file]");
        printStream.println("   --query file         Read one query from a file");
        printStream.println("   --syntax SYN         Query syntax");
        printStream.println("                            SPARQL (default), ARQ, RDQL, N3QL");
        printStream.println("                            File suffixes imply syntax:");
        printStream.println("                            .rq / SPARQL,  .arq / ARQ, .rdql / RDQL");
        printStream.println("   --graph URL          DataSource source (can also be part of query)");
        printStream.println("   --data URL           Synonym for --graph");
        printStream.println("   --namedGraph URL     DataSource source (can also be part of query)");
        printStream.println("   --named URL          Synonym for --namedGraph");
        printStream.println("                            URLs can be file: or http:");
        printStream.println("                            No schema => file:");
        printStream.println("                            Extensions used to guess the format as well");
        printStream.println("                                .rdf, .n3, .nt, .ttl");
        printStream.println("   --service URL        Execute query at given service");
        printStream.println("   --post               Force the use of HTTP POST");
        printStream.println("   --fmt FMT            Data source format: RDF/XML (default),");
        printStream.println("                            N3, N-TRIPLES, TURTLE");
        printStream.println("   --results FORM       Format of result");
        printStream.println("                          SELECT queries");
        printStream.println("                            text [default], count, tuples, none for display");
        printStream.println("                            rs, rs/graph, xml, json, rs/text for the result set ");
        printStream.println("                          CONSTRUCT and DESCRIBE queries");
        printStream.println("                            RDF, RDF/XML, N3, N-TRIPLES");
        printStream.println("                          ASK queries");
        printStream.println("                            xml, text");
        printStream.println("   --verbose            Verbose - more messages");
        printStream.println("   --quiet              Quiet - less messages");
        printStream.println("   --version            Print version information and exit");
        printStream.println("   -n --noExec          Don't actually execute the query");
        printStream.println("   --planning on | off  Turn off/on query planning");
        printStream.println("   --show WHAT          Print various internals details (parse trees, planning trees)");
        printStream.println("                        WHAT is currently 'plan' or 'query'");
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        defaultSyntax = Syntax.syntaxSPARQL;
        log = LogFactory.getLog((Class)query.class);
    }
}

