/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdUtils;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetFormat;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.OutputStream;
import java.io.PrintStream;

public class rset {
    static String usage;

    public static void main(String[] stringArray) {
        int n;
        CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        ArgDecl argDecl6 = new ArgDecl(true, "file");
        cmdLineArgs.add(argDecl);
        cmdLineArgs.add(argDecl3);
        cmdLineArgs.add(argDecl2);
        cmdLineArgs.add(argDecl4);
        cmdLineArgs.add(argDecl5);
        cmdLineArgs.add(argDecl6);
        try {
            cmdLineArgs.process();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (cmdLineArgs.contains(argDecl2)) {
            rset.usage();
            System.exit(0);
        }
        ResultSetFormat resultSetFormat = null;
        if (cmdLineArgs.contains(argDecl4) && (resultSetFormat = ResultSetFormat.lookup(cmdLineArgs.getValue(argDecl4))).equals(ResultSetFormat.syntaxText)) {
            System.err.println("Can't read in the tabular text format");
            System.exit(2);
        }
        ResultSetFormat resultSetFormat2 = null;
        if (cmdLineArgs.contains(argDecl5)) {
            resultSetFormat2 = ResultSetFormat.lookup(cmdLineArgs.getValue(argDecl5));
        }
        String string = null;
        if (cmdLineArgs.contains(argDecl6)) {
            string = cmdLineArgs.getValue(argDecl6);
        }
        if (string == null && (n = 0) < cmdLineArgs.getNumPositional()) {
            String string2;
            string = string2 = cmdLineArgs.getPositionalArg(n);
        }
        if (string != null && resultSetFormat == null) {
            resultSetFormat = ResultSetFormat.guessSyntax(string);
        }
        if (resultSetFormat == null) {
            resultSetFormat = ResultSetFormat.syntaxRDF;
        }
        if (resultSetFormat2 == null) {
            resultSetFormat2 = ResultSetFormat.syntaxText;
        }
        ResultSet resultSet = rset.parseResultSet(string, resultSetFormat);
        rset.printResultSet(resultSet, resultSetFormat2);
    }

    static ResultSet parseResultSet(String string, ResultSetFormat resultSetFormat) {
        if (string == null) {
            rset.msg("No file input");
            System.exit(9);
        }
        if (string.equals("-")) {
            return ResultSetFactory.load(System.in, resultSetFormat);
        }
        ResultSet resultSet = ResultSetFactory.load(string, resultSetFormat);
        if (resultSet == null) {
            System.exit(9);
        }
        return resultSet;
    }

    private static void printResultSet(ResultSet resultSet, ResultSetFormat resultSetFormat) {
        if (resultSetFormat.equals(ResultSetFormat.syntaxXML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, resultSet);
            return;
        }
        if (resultSetFormat.isCompatibleWith(ResultSetFormat.syntaxRDF)) {
            Model model = ResultSetFormatter.toModel(resultSet);
            String string = "RDF/XML-ABBREV";
            if (resultSetFormat.equals(ResultSetFormat.syntaxRDF_N3)) {
                string = "N3";
            }
            if (resultSetFormat.equals(ResultSetFormat.syntaxRDF_TTL)) {
                string = "N3";
            }
            if (resultSetFormat.equals(ResultSetFormat.syntaxRDF_NT)) {
                string = "N-TRIPLES";
            }
            model.write((OutputStream)System.out, string);
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxText)) {
            ResultSetFormatter.out((OutputStream)System.out, resultSet);
            return;
        }
        if (resultSetFormat.equals(ResultSetFormat.syntaxJSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, resultSet);
            return;
        }
        rset.msg("Unknown output syntax: " + resultSetFormat);
        System.exit(9);
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static void usage() {
        rset.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        usage = rset.class.getName() + " [--in syntax] [--out syntax] [--file FILE | FILE ]\n" + "  where syntax is one of XML, RDF";
    }
}

