/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.JSONOutput;
import com.hp.hpl.jena.query.resultset.RDFOutput;
import com.hp.hpl.jena.query.resultset.ResultSetFormat;
import com.hp.hpl.jena.query.resultset.TextOutput;
import com.hp.hpl.jena.query.resultset.XMLOutput;
import com.hp.hpl.jena.query.resultset.XMLOutputASK;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.LogFactory;

public class ResultSetFormatter {
    public static void out(OutputStream out, ResultSet qresults) {
        ResultSetFormatter.out(out, qresults, (PrefixMapping)null);
    }

    public static void out(OutputStream out, ResultSet qresults, Query query2) {
        ResultSetFormatter.out(out, qresults, query2.getPrefixMapping());
    }

    public static void out(OutputStream out, ResultSet qresults, PrefixMapping pmap) {
        TextOutput tFmt = new TextOutput(pmap);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, boolean answer) {
        TextOutput tFmt = new TextOutput((SerializationContext)null);
        tFmt.format(out, answer);
    }

    public static int consume(ResultSet resultSet) {
        int count = 0;
        while (resultSet.hasNext()) {
            resultSet.nextSolution();
            ++count;
        }
        return count;
    }

    public static Model toModel(ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.toModel(resultSet);
    }

    public static Model toModel(boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.toModel(booleanResult);
    }

    public static Resource asRDF(Model model, ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, resultSet);
    }

    public static Resource asRDF(Model model, boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, booleanResult);
    }

    public static void output(OutputStream outStream, ResultSet resultSet, ResultSetFormat rFmt) {
        if (rFmt.equals(ResultSetFormat.syntaxXML)) {
            ResultSetFormatter.outputAsXML(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxText)) {
            ResultSetFormatter.out(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxJSON)) {
            ResultSetFormatter.outputAsJSON(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxRDF)) {
            ResultSetFormatter.outputAsRDF(outStream, "RDF/XML-ABBREV", resultSet);
            return;
        }
        LogFactory.getLog((Class)ResultSetFormatter.class).warn((Object)("Unknown ResultSetFormat: " + rFmt));
    }

    public static void outputAsRDF(OutputStream outStream, String format, ResultSet resultSet) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)outStream);
        ResultSetFormatter.outputAsRDF(out, format, resultSet);
        out.flush();
    }

    private static void outputAsRDF(PrintWriter out, String format, ResultSet resultSet) {
        Model m = ResultSetFormatter.toModel(resultSet);
        m.write((Writer)out, format);
        out.flush();
    }

    public static void outputAsRDF(OutputStream outStream, String format, boolean booleanResult) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)outStream);
        ResultSetFormatter.outputAsRDF(out, format, booleanResult);
        out.flush();
    }

    private static void outputAsRDF(PrintWriter out, String format, boolean booleanResult) {
        Model m = ResultSetFormatter.toModel(booleanResult);
        m.write((Writer)out, format);
        out.flush();
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, Query query2) {
        ResultSetFormatter.outputAsXML(outStream, qresults);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults) {
        ResultSetFormatter.outputAsXML(outStream, qresults, (String)null);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        xOut.format(outStream, qresults);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.outputAsXML(outStream, booleanResult, null);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult, String stylesheet) {
        XMLOutputASK fmt = new XMLOutputASK(outStream, stylesheet);
        fmt.exec(booleanResult);
    }

    public static String asXMLString(ResultSet qresults) {
        return ResultSetFormatter.asXMLString(qresults, null);
    }

    public static String asXMLString(ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(qresults);
    }

    public static String asXMLString(boolean booleanResult) {
        return ResultSetFormatter.asXMLString(booleanResult, null);
    }

    public static String asXMLString(boolean booleanResult, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(booleanResult);
    }

    public static void outputAsJSON(OutputStream outStream, ResultSet resultSet) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, resultSet);
    }

    public static void outputAsJSON(OutputStream outStream, boolean booleanResult) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, booleanResult);
    }
}

