/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class DataSourceImpl
implements DataSource {
    Model defaultModel = null;
    Map namedModels = new HashMap();
    Lock lock = new LockMRSW();

    public DataSourceImpl() {
    }

    public DataSourceImpl(Dataset Dataset2) {
        if (!(Dataset2 instanceof DataSourceImpl)) {
            LogFactory.getLog((Class)DataSourceImpl.class).fatal((Object)"Clone Dataset: only DataSourceImpl supported");
            return;
        }
        DataSourceImpl ds = (DataSourceImpl)Dataset2;
        this.namedModels.putAll(ds.namedModels);
        this.defaultModel = ds.defaultModel;
    }

    public DataSourceImpl(DatasetGraph dataset) {
        this.cloneFromDatasetGraph(dataset);
    }

    public DataSourceImpl(Model m) {
        this();
        this.setDefaultModel(m);
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    public Model getNamedModel(String uri) {
        return (Model)this.namedModels.get(uri);
    }

    public boolean containsNamedModel(String uri) {
        return this.namedModels.containsKey(uri);
    }

    public Iterator listNames() {
        return this.namedModels.keySet().iterator();
    }

    public void close() {
        Iterator iter = this.listNames();
        while (iter.hasNext()) {
            Model m = (Model)iter.next();
            m.close();
        }
        this.namedModels.clear();
        if (this.defaultModel != null) {
            this.defaultModel.close();
        }
    }

    public void setDefaultModel(Model model) {
        this.defaultModel = model;
    }

    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        if (this.namedModels.containsKey(uri)) {
            throw new LabelExistsException("URI: " + uri);
        }
        this.namedModels.put(uri, model);
    }

    public void removeNamedModel(String uri) {
        this.removeNamedGraph(uri);
    }

    public void removeNamedGraph(String uri) {
        this.namedModels.remove(uri);
    }

    public void replaceNamedModel(String uri, Model model) {
        this.removeNamedModel(uri);
        this.addNamedModel(uri, model);
    }

    public String toString() {
        String s = "{";
        s = this.getDefaultModel() == null ? s + "<null>" : s + "[" + this.getDefaultModel().size() + "]";
        Iterator iter = this.listNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            s = s + ", (" + name + ", [" + this.getNamedModel(name).size() + "])";
        }
        s = s + "}";
        return s;
    }

    public Lock getLock() {
        return this.lock;
    }

    private void cloneFromDatasetGraph(DatasetGraph dataset) {
        if (dataset.getDefaultGraph() != null) {
            this.defaultModel = ModelFactory.createModelForGraph((Graph)dataset.getDefaultGraph());
        }
        Iterator iter = dataset.listNames();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            Graph g = dataset.getNamedGraph(uri);
            if (g == null) continue;
            Model m = ModelFactory.createModelForGraph((Graph)g);
            this.addNamedModel(uri, m);
        }
    }
}

