/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFatalException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.util.Utils;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;

public abstract class QueryIteratorBase
implements QueryIterator {
    private Log log = null;
    private boolean finished = false;

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected boolean isFinished() {
        return this.finished;
    }

    public final boolean hasNext() {
        try {
            if (this.finished) {
                if (this.logp()) {
                    this.logMsg("hasNext: already closed");
                }
                return false;
            }
            boolean r = this.hasNextBinding();
            if (!r) {
                if (this.logp()) {
                    this.logMsg("hasNext: autoClose");
                }
                this.close();
            }
            if (this.logp()) {
                this.logMsg("hasNext: => " + (r ? "true" : "false"));
            }
            return r;
        }
        catch (QueryFatalException ex) {
            this.log.warn((Object)"QueryFatalException", (Throwable)((Object)ex));
            this.abort();
            throw ex;
        }
    }

    public final Object next() {
        return this.nextBinding();
    }

    public final Binding nextBinding() {
        try {
            if (this.finished) {
                if (this.logp()) {
                    this.logMsg("next: already closed");
                }
                throw new NoSuchElementException();
            }
            if (!this.hasNextBinding()) {
                if (this.logp()) {
                    this.logMsg("next: No more");
                }
                throw new NoSuchElementException(Utils.className(this));
            }
            Binding obj = this.moveToNextBinding();
            if (this.logp()) {
                this.logMsg("next: " + obj);
            }
            if (obj == null) {
                throw new NoSuchElementException(Utils.className(this));
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            this.log.warn((Object)"QueryFatalException", (Throwable)((Object)ex));
            this.abort();
            throw ex;
        }
    }

    public final void remove() {
        this.getLog().warn((Object)("Call to QueryIterator.remove() : " + Utils.className(this) + ".remove"));
        throw new UnsupportedOperationException(Utils.className(this) + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            this.log.warn((Object)"QueryException in close()", (Throwable)((Object)ex));
        }
        this.finished = true;
    }

    public void abort() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        this.finished = true;
    }

    public String toString() {
        return Utils.className(this);
    }

    private Log getLog() {
        return this.log;
    }

    private boolean logp() {
        if (this.log == null) {
            return false;
        }
        return this.log.isDebugEnabled();
    }

    private void logMsg(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.debug((Object)msg);
    }
}

