/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasicPattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

public class PlanFormatter
implements PlanVisitor {
    static final int INDENT = 2;
    IndentedWriter out;
    SerializationContext context;
    private static boolean defaultClosingBracketOnSameLine = true;
    private boolean closingBracketOnSameLine = defaultClosingBracketOnSameLine;

    public static void out(OutputStream outStream, Plan plan) {
        PlanFormatter.out(outStream, plan.getRoot());
    }

    public static void out(IndentedWriter w, Plan plan) {
        PlanFormatter.out(w, plan.getRoot());
    }

    public static void out(OutputStream outStream, Query query2, Plan plan) {
        PlanFormatter.out(outStream, plan.getRoot());
    }

    public static void out(OutputStream outStream, PrefixMapping pmap, Plan plan) {
        PlanFormatter.out(outStream, pmap, plan.getRoot());
    }

    public static void out(IndentedWriter w, PlanElement pElt) {
        PlanFormatter.out(w, (PrefixMapping)null, pElt);
    }

    public static void out(OutputStream outStream, PlanElement pElt) {
        PlanFormatter.out(outStream, (PrefixMapping)null, pElt);
    }

    public static void out(OutputStream outStream, PrefixMapping pmap, PlanElement pElt) {
        IndentedWriter w = new IndentedWriter(outStream);
        PlanFormatter.out(w, pmap, pElt);
    }

    public static void out(OutputStream outStream, Query query2, PlanElement pElt) {
        IndentedWriter w = new IndentedWriter(outStream);
        PlanFormatter.out(w, query2, pElt);
    }

    public static void out(IndentedWriter w, Query query2, PlanElement pElt) {
        PrefixMapping pmap = null;
        if (query2 != null && query2.getPrefixMapping() != null) {
            pmap = query2.getPrefixMapping();
        }
        PlanFormatter.out(w, pmap, pElt);
    }

    public static void out(IndentedWriter w, PrefixMapping pmap, PlanElement pElt) {
        PlanFormatter fmt = new PlanFormatter(w, pmap);
        fmt.startVisit();
        pElt.visit(fmt);
        fmt.finishVisit();
    }

    private void startVisit() {
    }

    private void finishVisit() {
        this.out.newline();
        this.out.flush();
    }

    public PlanFormatter(IndentedWriter w, PrefixMapping pmap) {
        this(w, new SerializationContext(pmap));
    }

    public PlanFormatter(IndentedWriter w, SerializationContext context) {
        this.out = w;
        this.context = context;
        this.closingBracketOnSameLine = defaultClosingBracketOnSameLine;
    }

    public void visit(PlanBasicPattern planElt) {
        this.start("BasePattern");
        if (planElt.getPattern().size() == 1 && planElt.getConstraints().size() == 0) {
            this.out.print(" ");
            Triple t = (Triple)planElt.getPattern().get(0);
            this.formatTriple(t);
            this.finish();
            return;
        }
        this.out.incIndent(2);
        Iterator iter = planElt.getPattern().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.formatTriple(t);
        }
        this.out.incIndent(2);
        iter = planElt.getConstraints().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Expression e2 = (Expression)iter.next();
            this.out.print("Constraint: ");
            this.out.print(e2.toString());
        }
        this.out.decIndent(2);
        if (this.closingBracketOnSameLine) {
            this.out.newline();
        }
        this.out.decIndent(2);
        this.finish();
    }

    public void visit(PlanTriplePattern planElt) {
        this.start("TriplePattern");
        this.out.print(" ");
        Triple t = planElt.getTriple();
        this.formatTriple(t);
        this.finish();
    }

    public void visit(PlanGroup planElt) {
        String s = "Group";
        if (!planElt.canReorder()) {
            s = "Group(fixed)";
        }
        this.multipleSubPlans(s, planElt.getPlanElements().iterator());
    }

    public void visit(PlanUnion planElt) {
        this.multipleSubPlans("Union", planElt.getPlanElements().iterator());
    }

    public void visit(PlanOptional planElt) {
        this.singleSubPlan("Optional", planElt.getSub());
    }

    public void visit(PlanUnsaid planElt) {
        this.singleSubPlan("Unsaid", planElt.getSub());
    }

    public void visit(PlanFilter planElt) {
        this.start("Constraint");
        this.out.print(" ");
        Constraint c = planElt.getConstraint();
        if (c.isExpr()) {
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            c.getExpr().visit(v);
        } else {
            this.out.print(c.toString());
        }
        this.out.print("]");
    }

    public void visit(PlanNamedGraph planElt) {
        this.singleSubPlan("NamedGraph", planElt.getSub());
    }

    public void visit(PlanOuterJoin planElt) {
        this.multipleSubPlans("OuterJoin", planElt.getPlanElements().iterator());
    }

    public void visit(PlanExtension planElt) {
        this.start("Extension");
        this.out.print(" <");
        this.out.print(planElt.getElement().getURI());
        this.out.print(">");
        this.finish();
    }

    public void visit(PlanBlock planElt) {
        this.singleSubPlan("Block", planElt.getSub());
    }

    public void visit(PlanDistinct planElt) {
        this.singleSubPlan("Distinct", planElt.getSub(), planElt.getVars());
    }

    public void visit(PlanProject planElt) {
        this.singleSubPlan("Project", planElt.getSub(), planElt.getVars());
    }

    public void visit(PlanOrderBy planElt) {
        this.singleSubPlan("OrderBy", planElt.getSub());
    }

    public void visit(PlanLimitOffset planElt) {
        this.singleSubPlan("LimitOffset", planElt.getSub());
    }

    private void plainPlan(String label) {
        this.start(label);
        this.finish();
    }

    private void singleSubPlan(String label, PlanElement subElt) {
        this.singleSubPlan(label, subElt, null);
    }

    private void singleSubPlan(String label, PlanElement subElt, Collection vars) {
        this.start(label);
        if (vars != null) {
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                String vn = (String)iter.next();
                this.out.print(" ?");
                this.out.print(vn);
            }
        }
        this.out.incIndent(2);
        if (subElt != null) {
            this.out.println();
            subElt.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void multipleSubPlans(String label, Iterator iter) {
        this.start(label);
        this.out.incIndent(2);
        while (iter.hasNext()) {
            this.out.newline();
            PlanElement element = (PlanElement)iter.next();
            element.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void start(String name) {
        this.out.print("[");
        this.out.print(name);
    }

    private void finish() {
        if (this.closingBracketOnSameLine) {
            this.out.print("]");
        } else {
            this.out.println();
            this.out.print("]");
        }
    }

    private void formatTriple(Triple tp) {
        this.out.print(this.slotToString(tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getObject()));
    }

    private String slotToString(Node n) {
        return FmtUtils.stringForNode(n, this.context);
    }
}

