/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.vocabulary.ListMember;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyFunctionRegistry {
    static PropertyFunctionRegistry globalRegistry = null;
    Map registry = new HashMap();

    public static synchronized PropertyFunctionRegistry standardRegistry() {
        PropertyFunctionRegistry reg = new PropertyFunctionRegistry();
        reg.loadStdDefs();
        return reg;
    }

    public static synchronized PropertyFunctionRegistry get() {
        PropertyFunctionRegistry reg = (PropertyFunctionRegistry)EngineConfig.getContext().get(EngineConfig.registryMagicProperties);
        if (reg == null) {
            reg = PropertyFunctionRegistry.standardRegistry();
            EngineConfig.getContext().set(EngineConfig.registryMagicProperties, reg);
        }
        return reg;
    }

    private void loadStdDefs() {
        this.put(ListMember.member.asNode(), "java:com.hp.hpl.jena.query.extension.library.list");
        this.put(RDFS.member.asNode(), "java:com.hp.hpl.jena.query.extension.library.container");
    }

    public void put(String uri, String extension) {
        this.registry.put(Node.createURI((String)uri), extension);
    }

    private void put(Node node, String extension) {
        this.registry.put(node, extension);
    }

    public String get(String uri) {
        return this.get(Node.create((String)uri));
    }

    public String get(Node node) {
        return (String)this.registry.get(node);
    }

    public String get(RDFNode p) {
        return this.get(p.asNode());
    }

    public boolean contains(String uri) {
        return this.contains(Node.create((String)uri));
    }

    public boolean contains(Node node) {
        return this.registry.containsKey(node);
    }

    public boolean contains(RDFNode p) {
        return this.contains(p.asNode());
    }

    public String remove(String uri) {
        return this.remove(Node.create((String)uri));
    }

    public String remove(Node node) {
        return (String)this.registry.remove(node);
    }

    public String remove(RDFNode p) {
        return this.remove(p.asNode());
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }
}

