/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.QueryIterConstraintFilter;
import com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprCheck;
import com.hp.hpl.jena.query.expr.ExprWalker;
import org.apache.commons.logging.LogFactory;

public class PlanFilter
extends PlanElementBase {
    ElementFilter element;

    public static PlanElement make(Plan plan, ElementFilter el) {
        return new PlanFilter(plan, el);
    }

    private PlanFilter(Plan plan, ElementFilter el) {
        super(plan);
        this.element = el;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        if (input == null) {
            LogFactory.getLog((Class)PlanFilter.class).warn((Object)"Null input iterator");
            input = new QueryIterSingleton(Binding.createRootBinding(), execCxt);
        }
        if (this.element.getConstraint().isExpr()) {
            Expr ex = this.element.getConstraint().getExpr();
            ExprWalker.walk(new ExprCheck(), ex);
        }
        return new QueryIterConstraintFilter(input, this.element.getConstraint(), execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public Constraint getConstraint() {
        return this.element.getConstraint();
    }
}

