/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanFormatter;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.PropertyFunctionRegistry;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseFilters;
import com.hp.hpl.jena.query.engine1.analyse.AnalyseOrderSets;
import com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import com.hp.hpl.jena.query.engine1.compiler.GroupUtils;
import com.hp.hpl.jena.query.engine1.compiler.PlanBasicPattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.util.RefBoolean;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanGroup
extends PlanElementBase {
    static Log log = LogFactory.getLog((Class)PlanGroup.class);
    public static boolean enableOrderWarnings = true;
    List planElements = new ArrayList();
    private boolean canReorder = true;
    public static RefBoolean enableMagicProperties = new RefBoolean(EngineConfig.getContext(), ARQ.enablePropertyFunctions);

    public static PlanElement make(Plan plan, List acc) {
        if (acc.size() == 1 && !(acc.get(0) instanceof PlanTriplePattern)) {
            return (PlanElement)acc.get(0);
        }
        return new PlanGroup(plan, acc, true);
    }

    public static PlanGroup make(Plan plan, List acc, boolean reorderable) {
        return new PlanGroup(plan, acc, reorderable);
    }

    public boolean canReorder() {
        return this.canReorder;
    }

    private PlanGroup(Plan plan, List subElts, boolean reorderable) {
        super(plan);
        this.planElements = subElts;
        this.canReorder = reorderable;
        this.rewriteMagicProperties(this.planElements, plan);
        this.planElements = this.compressBasicPatterns(this.planElements, plan);
        if (plan.getContext().isTrue(ARQ.orderPlanning)) {
            this.planGroup();
        }
    }

    private void planGroup() {
        if (!this.canReorder) {
            return;
        }
        AnalyseOrderSets aOpt = new AnalyseOrderSets(this);
        this.planElements = aOpt.reorder();
        AnalyseFilters aFlt = new AnalyseFilters(this);
        this.planElements = aFlt.reorder();
    }

    public List getPlanElements() {
        return this.planElements;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        if (this.planElements.size() == 0) {
            return input;
        }
        if (this.planElements.size() == 1) {
            PlanElement e2 = (PlanElement)this.planElements.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)"New group stage (1 step)");
            }
            return e2.build(input, execCxt);
        }
        int count = 0;
        ListIterator elementsIterator = this.planElements.listIterator();
        QueryIterator chain = input;
        while (elementsIterator.hasNext()) {
            QueryIterator cIter;
            ++count;
            PlanElement element = (PlanElement)elementsIterator.next();
            if (element == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"New group stage");
            }
            chain = cIter = element.build(chain, execCxt);
        }
        return chain;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    private void rewriteMagicProperties(List pElts, Plan plan) {
        if (!enableMagicProperties.getValue()) {
            return;
        }
        PropertyFunctionRegistry registry = (PropertyFunctionRegistry)plan.getContext().get(EngineConfig.registryMagicProperties);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        for (int i = 0; i < pElts.size(); ++i) {
            PlanTriplePattern etp;
            Triple t;
            PlanElement e2 = (PlanElement)pElts.get(i);
            if (!(e2 instanceof PlanTriplePattern) || !registry.contains((t = (etp = (PlanTriplePattern)e2).getTriple()).getPredicate())) continue;
            String extURI = registry.get(t.getPredicate());
            ArrayList<Expr> args = new ArrayList<Expr>();
            Expr sExpr = this.asExpr(t.getSubject());
            Expr oExpr = this.asExpr(t.getObject());
            args.add(sExpr);
            args.add(oExpr);
            ElementExtension eExt = new ElementExtension(extURI, args, null);
            PlanElement e22 = PlanExtension.make(plan, eExt);
            pElts.set(i, e22);
        }
    }

    private Expr asExpr(Node n) {
        if (n.isVariable()) {
            return new NodeVar(n.getName());
        }
        return NodeValue.makeNode(n);
    }

    private List compressBasicPatterns(List pElts, Plan plan) {
        ArrayList<PlanElement> newPlanElements = new ArrayList<PlanElement>();
        for (int i = 0; i < pElts.size(); ++i) {
            int j;
            PlanElement e2 = (PlanElement)pElts.get(i);
            if (!(e2 instanceof PlanTriplePattern)) {
                newPlanElements.add(e2);
                continue;
            }
            PlanTriplePattern etp = (PlanTriplePattern)e2;
            PlanBasicPattern basePatterns = new PlanBasicPattern(this.getPlan());
            basePatterns.getPattern().add(etp.getTriple());
            newPlanElements.add(basePatterns);
            for (j = i + 1; j < pElts.size(); ++j) {
                PlanElement e22 = (PlanElement)pElts.get(j);
                if (!(e22 instanceof PlanTriplePattern)) {
                    boolean handled = GroupUtils.optimizableConstraint(basePatterns, e22, plan);
                    if (handled) break;
                    newPlanElements.add(e22);
                    break;
                }
                PlanTriplePattern etp2 = (PlanTriplePattern)e22;
                basePatterns.addTriple(etp2.getTriple());
            }
            i = j;
        }
        return newPlanElements;
    }

    private void warnOrderDependence(AnalyseOrderSets a) {
        Iterator iter = a.getEquivalenceSets().iterator();
        while (iter.hasNext()) {
            Set r = (Set)iter.next();
            if (!enableOrderWarnings || r.size() == 1) continue;
            log.warn((Object)"Potential order dependence");
            Iterator pEltIter = r.iterator();
            while (pEltIter.hasNext()) {
                PlanElement e2 = (PlanElement)pEltIter.next();
                PlanFormatter.out((OutputStream)System.out, e2);
            }
        }
    }

    public void varsReport() {
        String vn;
        VarUsageVisitor varUsage = new VarUsageVisitor();
        this.visit(varUsage);
        System.out.println();
        System.out.print("Fixed:  ");
        Iterator iter = varUsage.getFixedUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
        System.out.print("Varying:");
        iter = varUsage.getOptionalUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
        System.out.print("Constrained:");
        iter = varUsage.getConstraintUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
    }
}

