/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.ElementWalker;
import com.hp.hpl.jena.query.engine1.Plan;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import java.util.ArrayList;
import java.util.Stack;

public class QueryCompilerVisitor
implements ElementVisitor {
    protected Plan plan = null;
    private Stack retStack = new Stack();

    public QueryCompilerVisitor(Plan plan) {
        this.plan = plan;
    }

    public PlanElement compile(Element el) {
        ElementWalker.walk(el, this);
        if (this.retStack.size() != 1) {
            throw new ARQInternalErrorException("Plan compilation stack is not the expected size");
        }
        PlanElement cElt = (PlanElement)this.retStack.pop();
        return cElt;
    }

    public void visit(ElementTriplePattern el) {
        PlanElement cElt = PlanTriplePattern.make(this.plan, el);
        this.push(cElt);
    }

    public void visit(ElementFilter el) {
        PlanElement cElt = PlanFilter.make(this.plan, el);
        this.push(cElt);
    }

    public void visit(ElementUnion el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        int z1 = this.retStack.size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        int z2 = this.retStack.size();
        PlanElement ex = PlanUnion.make(this.plan, acc);
        this.push(ex);
    }

    public void visit(ElementGroup el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        PlanElement ex = PlanGroup.make(this.plan, acc);
        this.push(ex);
    }

    public void visit(ElementBlock el) {
        PlanElement cSubElt = null;
        if (el.getPatternElement() != null) {
            cSubElt = this.pop();
        }
        PlanElement cElt = PlanBlock.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementOptional el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanOptional.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementNamedGraph el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanNamedGraph.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementUnsaid el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanUnsaid.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementExtension el) {
        PlanElement cElt = PlanExtension.make(this.plan, el);
        this.push(cElt);
    }

    private void push(PlanElement cElt) {
        this.retStack.push(cElt);
    }

    private PlanElement pop() {
        return (PlanElement)this.retStack.pop();
    }
}

