/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.Function;
import com.hp.hpl.jena.query.function.FunctionFactory;
import com.hp.hpl.jena.query.function.FunctionRegistry;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class E_Function
extends ExprNodeFunction {
    private static final String symbol = "function";
    public static boolean WarnOnUnknownFunction = true;
    private List args = null;
    private String name = null;
    private Function function = null;
    private boolean functionBound = false;

    public E_Function(String name, List args) {
        super(symbol);
        this.name = name;
        this.args = args;
    }

    public void checkFunction() {
        block2: {
            try {
                this.bindFunction();
            }
            catch (ExprException ex) {
                if (!WarnOnUnknownFunction) break block2;
                LogFactory.getLog((Class)E_Function.class).warn((Object)("URI '" + this.name + "' has no registered function factory"));
            }
        }
    }

    private void bindFunction() {
        if (this.functionBound) {
            return;
        }
        FunctionFactory ff = FunctionRegistry.get().get(this.name);
        if (ff == null) {
            this.functionBound = true;
            throw new ExprEvalException("URI '" + this.name + "' not found as a function");
        }
        this.function = ff.create(this.name);
        this.function.build(this.name, this.args);
        this.functionBound = true;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        this.bindFunction();
        if (this.function == null) {
            throw new ExprEvalException("URI '" + this.name + "' not bound");
        }
        NodeValue r = this.function.exec(binding, this.args, this.name, execCxt);
        return r;
    }

    public void check() {
    }

    public Expr getArg(int i) {
        if (this.args.size() <= --i) {
            return null;
        }
        return (Expr)this.args.get(i);
    }

    public int numArgs() {
        return this.args.size();
    }

    public String getPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.name, cxt);
    }
}

