/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;

public class E_LogicalOr
extends ExprNode2 {
    private static final String printName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(Expr left, Expr right) {
        super(left, right, symbol, printName);
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.left.eval(binding, execCxt);
            if (Functions.effectiveBooleanValue(x)) {
                return NodeValue.TRUE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.right.eval(binding, execCxt);
            if (Functions.effectiveBooleanValue(y)) {
                return NodeValue.TRUE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.FALSE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }
}

