/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNotComparableException;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueBoolean;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDate;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueNode;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueString;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.query.util.RefBoolean;
import com.hp.hpl.jena.query.util.RomanNumeral;
import com.hp.hpl.jena.query.util.RomanNumeralDatatype;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NodeValue
extends ExprNode {
    private static Log log = LogFactory.getLog((Class)NodeValue.class);
    public static boolean VerboseWarnings = true;
    public static boolean VerboseExceptions = false;
    public static final NodeValue TRUE = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
    public static final NodeValue FALSE = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
    public static final BigInteger IntegerZERO = new BigInteger("0");
    public static final BigDecimal DecimalZERO = new BigDecimal("0");
    private static final boolean sameValueAsString = JenaParameters.enablePlainLiteralSameAsString;
    private static RefBoolean enableRomanNumerals = new RefBoolean(ARQ.getContext(), ARQ.enableRomanNumerals);
    private Node node = null;
    private static final int CLASS_UNDEF = -5;
    private static final int CLASS_NUM = 10;
    private static final int CLASS_DATETIME = 11;
    private static final int CLASS_STRING = 12;
    private static final int CLASS_BOOLEAN = 13;
    private static final int CLASS_NODE = 14;

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(new BigDecimal(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDate(Calendar cal) {
        return new NodeValueDate(cal);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = NodeValue.nodeToNodeValue(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, XSDDatatype dtype) {
        Node n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            log.warn((Object)("Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')"));
        }
        Node n = null;
        if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xboolean.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(float f) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(f), null, XSD.xfloat.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(v), null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(decimal), null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.decimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = Utils.calendarToXSDDateTimeString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        return this;
    }

    public NodeValue evalNodeValue(Binding binding, ExecutionContext execCxt) {
        System.err.println("eval - convert back to NodeValue");
        return null;
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    public boolean isConstant() {
        return true;
    }

    public NodeValue getConstant() {
        return this;
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to sameValueAs on null");
        }
        int compType = NodeValue.classifyOP(nv1, nv2, true);
        switch (compType) {
            case 10: {
                return Functions.compareNumeric(nv1, nv2) == 0;
            }
            case 11: {
                return Functions.compareDateTime(nv1, nv2) == 0;
            }
            case 12: {
                return Functions.compareString(nv1, nv2) == 0;
            }
            case 13: {
                return Functions.compareBoolean(nv1, nv2) == 0;
            }
            case 14: {
                return nv1.getNode().equals((Object)nv2.getNode());
            }
        }
        NodeValue.raise(new ExprEvalException("Can't sameValueAs " + nv1 + " and " + nv2));
        return false;
    }

    public static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to notSameValueAs on null");
        }
        int compType = NodeValue.classifyOP(nv1, nv2, true);
        switch (compType) {
            case 10: {
                return Functions.compareNumeric(nv1, nv2) != 0;
            }
            case 11: {
                return Functions.compareDateTime(nv1, nv2) != 0;
            }
            case 12: {
                return Functions.compareString(nv1, nv2) != 0;
            }
            case 13: {
                return Functions.compareBoolean(nv1, nv2) != 0;
            }
            case 14: {
                String lang2;
                if (nv1.hasKnownValue() && nv2.hasKnownValue()) {
                    return true;
                }
                Node n1 = nv1.getNode();
                Node n2 = nv2.getNode();
                if (!nv1.getNode().isLiteral() || !n2.isLiteral()) {
                    return !n1.equals((Object)nv2.getNode());
                }
                String dt1 = n1.getLiteralDatatypeURI();
                String dt2 = n2.getLiteralDatatypeURI();
                if (sameValueAsString) {
                    if (dt1 != null && dt1.equals(XSDDatatype.XSDstring.getURI())) {
                        dt1 = null;
                    }
                    if (dt2 != null && dt2.equals(XSDDatatype.XSDstring.getURI())) {
                        dt2 = null;
                    }
                }
                String lex1 = n1.getLiteralLexicalForm();
                String lex2 = n2.getLiteralLexicalForm();
                String lang1 = n1.getLiteralLanguage();
                if (lang1 == null) {
                    lang1 = "";
                }
                if ((lang2 = n2.getLiteralLanguage()) == null) {
                    lang2 = "";
                }
                if (dt1 == null && dt2 == null) {
                    if (lang1.equals("") && lang2.equals("")) {
                        log.warn((Object)"Internal error: Should be string comparisons, not unknown literals types");
                        return !lex1.equals(lex2);
                    }
                    if (!lang1.equals(lang2)) {
                        return true;
                    }
                    return !lex1.equals(lex2);
                }
                if (dt1 == null && dt2 != null) {
                    return true;
                }
                if (dt2 == null && dt1 != null) {
                    return true;
                }
                if (!dt1.equals(dt2)) {
                    return false;
                }
                return false;
            }
        }
        throw new ARQInternalErrorException("Failed to carry out a noSameValueAs test");
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        try {
            return NodeValue.compare(nv1, nv2, true);
        }
        catch (ExprNotComparableException ex) {
            nv1.forceToNode();
            nv2.forceToNode();
            return NodeUtils.compareNodesByKindTypeLexical(nv1.getNode(), nv2.getNode());
        }
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            new ARQInternalErrorException("Attempt to compare on null");
        }
        int x = NodeValue.compare(nv1, nv2, false);
        return x;
    }

    private static int compare(NodeValue nv1, NodeValue nv2, boolean generalCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        int compType = NodeValue.classifyOP(nv1, nv2, generalCompare);
        if (compType == 13 && !generalCompare) {
            compType = -5;
        }
        switch (compType) {
            case 10: {
                return Functions.compareNumeric(nv1, nv2);
            }
            case 11: {
                return Functions.compareDateTime(nv1, nv2);
            }
            case 12: {
                return Functions.compareString(nv1, nv2);
            }
            case 13: {
                return Functions.compareBoolean(nv1, nv2);
            }
        }
        if (!generalCompare) {
            NodeValue.raise(new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2));
        }
        throw new ExprNotComparableException("Can't compare " + nv1 + " and " + nv2);
    }

    private static int classifyOP(NodeValue nv1, NodeValue nv2, boolean mayForce) {
        int x = NodeValue.classifyStrict(nv1, nv2);
        if (x == -5 && mayForce) {
            nv1.forceToNode();
            nv2.forceToNode();
            x = 14;
        }
        return x;
    }

    private static int classifyStrict(NodeValue nv1, NodeValue nv2) {
        if (nv1.isNumber()) {
            if (nv2.isNumber()) {
                return 10;
            }
            return -5;
        }
        if (nv2.isNumber()) {
            return -5;
        }
        if (nv1.isDate() && nv2.isDate()) {
            return 11;
        }
        if (nv1.isString() && nv2.isString()) {
            return 12;
        }
        if (nv1.isBoolean() && nv2.isBoolean()) {
            return 13;
        }
        return 14;
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean hasKnownValue() {
        return this.isBoolean() || this.isNumber() || this.isString() || this.isDate();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalException("Not a boolean: " + this));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalException("Not a string: " + this));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalException("Not an int: " + this));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalException("Not a decimal: " + this));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalException("Not a float: " + this));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalException("Not a double: " + this));
        return Double.NaN;
    }

    public Calendar getDate() {
        NodeValue.raise(new ExprEvalException("Not a date: " + this));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        boolean isPlainLiteral;
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        boolean hasLangTag = node.getLiteralLanguage() != null && !node.getLiteralLanguage().equals("");
        boolean bl = isPlainLiteral = node.getLiteralDatatypeURI() == null && !hasLangTag;
        if (isPlainLiteral) {
            return new NodeValueString(node.getLiteralLexicalForm(), node);
        }
        if (hasLangTag) {
            if (node.getLiteralDatatypeURI() != null) {
                if (VerboseWarnings) {
                    log.warn((Object)"Lang tag and datatype (datatype ignored)");
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Lang tag and datatype (datatype ignored)");
                }
            }
            return new NodeValueNode(node);
        }
        LiteralLabel lit = node.getLiteral();
        if (!lit.getDatatype().isValidLiteral(lit)) {
            if (VerboseWarnings) {
                String tmp = FmtUtils.stringForNode(node, PrefixMapping.Standard);
                log.warn((Object)("Datatype format exception: " + tmp));
            } else if (log.isDebugEnabled()) {
                String tmp = FmtUtils.stringForNode(node, PrefixMapping.Standard);
                log.debug((Object)("Datatype format exception: " + tmp));
            }
            return new NodeValueNode(node);
        }
        NodeValue nv = NodeValue._setByValue(node);
        if (nv != null) {
            return nv;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unrecognized literal: " + node));
        }
        return new NodeValueNode(node);
    }

    private static NodeValue _setByValue(Node node) {
        LiteralLabel lit = node.getLiteral();
        try {
            if (sameValueAsString && XSDDatatype.XSDstring.isValidLiteral(node.getLiteral())) {
                return new NodeValueString(lit.getLexicalForm(), node);
            }
            if (!node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                long i = ((Number)lit.getValue()).longValue();
                return new NodeValueInteger(i, node);
            }
            if (XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                BigDecimal decimal = new BigDecimal(lit.getLexicalForm());
                return new NodeValueDecimal(decimal, node);
            }
            if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                float f = ((Number)lit.getValue()).floatValue();
                return new NodeValueFloat(f, node);
            }
            if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                return new NodeValueDouble(d, node);
            }
            if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                return new NodeValueDate(dateTime.asCalendar(), node);
            }
            if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                return new NodeValueBoolean(b, node);
            }
            if (enableRomanNumerals.getValue() && lit.getDatatypeURI().equals(RomanNumeralDatatype.get().getURI())) {
                RomanNumeral rn = (RomanNumeral)RomanNumeralDatatype.get().parse(lit.getLexicalForm());
                int i = rn.intValue();
                return new NodeValueInteger(i);
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return null;
    }

    public static void raise(ExprException ex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exception: " + ex.getMessage()));
        }
        throw ex;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + this));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(null);
    }

    public final String asQuotedString(SerializationContext context) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    public int hashCode() {
        this.forceToNode();
        return this.asNode().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        if (this.isInteger() && nv.isInteger()) {
            return this.getInteger().equals(nv.getInteger());
        }
        if (this.isBoolean() && nv.isBoolean()) {
            return this.getBoolean() == nv.getBoolean();
        }
        if (this.isDecimal() && nv.isDecimal()) {
            return this.getDecimal().compareTo(nv.getDecimal()) == 0;
        }
        if (this.isFloat() && nv.isFloat()) {
            return this.getFloat() == nv.getFloat();
        }
        if (this.isDouble() && nv.isDouble()) {
            return this.getDouble() == nv.getDouble();
        }
        if (this.isDate() && nv.isDate()) {
            return this.getDate().equals(nv.getDate());
        }
        if (this.isString() && nv.isString()) {
            return this.getString().equals(nv.getString());
        }
        this.asNode();
        nv.asNode();
        if (this.getNode() != null && nv.getNode() != null) {
            return this.getNode().equals((Object)nv.getNode());
        }
        return false;
    }

    public String toString() {
        return this.asQuotedString();
    }
}

