/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class FunctionBase
implements Function {
    String uri = null;
    protected List arguments = null;
    protected Binding currentBinding = null;
    protected ExecutionContext execCxt;

    public final void build(String uri, List args) {
        this.uri = uri;
        this.arguments = args;
        this.checkBuild(uri, args);
    }

    public NodeValue exec(Binding binding, List args, String uri, ExecutionContext execCxt) {
        this.execCxt = execCxt;
        if (args == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        ArrayList<NodeValue> evalArgs = new ArrayList<NodeValue>();
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr e2 = (Expr)iter.next();
            NodeValue x = e2.eval(binding, execCxt);
            evalArgs.add(x);
        }
        this.currentBinding = binding;
        NodeValue nv = this.exec(evalArgs);
        this.currentBinding = null;
        this.arguments = null;
        return nv;
    }

    public Binding getCurrentBinding() {
        return this.currentBinding;
    }

    public ExecutionContext getExecutionContext() {
        return this.execCxt;
    }

    public abstract NodeValue exec(List var1);

    public abstract void checkBuild(String var1, List var2);

    public NodeValue getArg(int i) {
        if (--i < 0 || i >= this.arguments.size()) {
            return null;
        }
        return (NodeValue)this.arguments.get(i);
    }
}

