/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function.library;

import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.FunctionBase1;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class sha1sum
extends FunctionBase1 {
    private static char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    NodeValue lastSeen = null;
    NodeValue lastCalc = null;

    public NodeValue exec(NodeValue nodeValue) {
        if (this.lastSeen != null && this.lastSeen.equals(nodeValue)) {
            return this.lastCalc;
        }
        if (nodeValue.asNode().isBlank()) {
            throw new ExprEvalException("Attempt to sha1 a blank node");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            String value = nodeValue.asString();
            String hex = this.getHexString(digest.digest(value.getBytes()));
            this.lastSeen = nodeValue;
            this.lastCalc = NodeValue.makeNodeString(hex);
            return this.lastCalc;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new ExprEvalException("Unable to get SHA1 digester", e2);
        }
    }

    private String getHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HEX_CHAR[(bytes[i] & 0xF0) >> 4]);
            sb.append(HEX_CHAR[bytes[i] & 0xF]);
        }
        return sb.toString();
    }
}

