/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.ManifestItemHandler;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.TestManifestX;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Manifest {
    private static Log log = LogFactory.getLog((Class)Manifest.class);
    Model manifest;
    String manifestName;
    String filename;
    List includedFiles = new ArrayList();
    Resource manifestRes = null;

    public Manifest(String fn) {
        log.debug((Object)("Manifest = " + fn));
        this.filename = RelURI.resolve(fn);
        log.debug((Object)("         = " + this.filename));
        this.manifest = FileManager.get().loadModel(this.filename);
        this.parseIncludes();
        this.parseManifest();
    }

    public String getName() {
        return this.manifestName;
    }

    public Iterator includedManifests() {
        return this.includedFiles.iterator();
    }

    private void parseManifest() {
        StmtIterator manifestStmts = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        if (!manifestStmts.hasNext()) {
            log.warn((Object)("No manifest in manifest file: " + this.filename));
            return;
        }
        Statement manifestItemStmt = manifestStmts.nextStatement();
        if (manifestStmts.hasNext()) {
            log.warn((Object)("Multiple manifests in manifest file: " + this.filename));
            return;
        }
        this.manifestRes = manifestItemStmt.getSubject();
        this.manifestName = TestUtils.getLiteral(this.manifestRes, RDFS.label);
        if (this.manifestName == null) {
            this.manifestName = TestUtils.getLiteral(this.manifestRes, RDFS.comment);
        }
        manifestStmts.close();
    }

    public void apply(ManifestItemHandler gen) {
        StmtIterator manifestStmts = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        while (manifestStmts.hasNext()) {
            Statement manifestItemStmt = manifestStmts.nextStatement();
            Resource manifestRes = manifestItemStmt.getSubject();
            StmtIterator listIter = manifestRes.listProperties(TestManifest.entries);
            while (listIter.hasNext()) {
                Resource listItem = listIter.nextStatement().getResource();
                while (!listItem.equals(RDF.nil)) {
                    Resource entry = listItem.getRequiredProperty(RDF.first).getResource();
                    String testName = TestUtils.getLiteral(entry, TestManifest.name);
                    Resource action = TestUtils.getResource(entry, TestManifest.action);
                    Resource result = TestUtils.getResource(entry, TestManifest.result);
                    gen.processManifestItem(manifestRes, entry, testName, action, result);
                    listItem = listItem.getRequiredProperty(RDF.rest).getResource();
                }
            }
            listIter.close();
        }
        manifestStmts.close();
    }

    private void parseIncludes() {
        StmtIterator includeStmts = this.manifest.listStatements(null, TestManifestX.include, (RDFNode)null);
        while (includeStmts.hasNext()) {
            Statement s = includeStmts.nextStatement();
            if (!(s.getObject() instanceof Resource)) {
                log.warn((Object)("Include: not a Resource" + s));
                continue;
            }
            Resource r = s.getResource();
            this.parseIncludes(r);
        }
        includeStmts.close();
    }

    private void parseIncludes(Resource r) {
        if (r == null) {
            return;
        }
        if (r.equals(RDF.nil)) {
            return;
        }
        if (!r.isAnon()) {
            String uri = r.getURI();
            if (this.includedFiles.contains(uri)) {
                return;
            }
            this.includedFiles.add(r.getURI());
            return;
        }
        Resource listItem = r;
        while (!listItem.equals(RDF.nil)) {
            r = listItem.getRequiredProperty(RDF.first).getResource();
            this.parseIncludes(r);
            listItem = listItem.getRequiredProperty(RDF.rest).getResource();
        }
    }
}

