/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Constants;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprNode1;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.serializer.FormatterExpr;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class FmtExprARQ
extends FormatterExpr {
    IndentedWriter out;
    SerializationContext context;

    public FmtExprARQ(IndentedWriter writer, SerializationContext cxt) {
        this.out = writer;
        this.context = cxt;
        if (this.context == null) {
            this.context = new SerializationContext(null, null, null);
        }
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Expr expr) {
        FmtExprARQ fmt = new FmtExprARQ(out, cxt);
        fmt.startVisit();
        expr.visit(fmt);
        fmt.finishVisit();
    }

    public void startVisit() {
    }

    public void visit(ExprNode1 expr) {
        this.out.print("( ");
        this.out.print(expr.getOpSymbol());
        this.out.print(" ");
        expr.getSubExpr().visit(this);
        this.out.print(" )");
    }

    public void visit(ExprNode2 expr) {
        this.out.print("( ");
        expr.getLeft().visit(this);
        this.out.print(" ");
        this.out.print(expr.getOpSymbol());
        this.out.print(" ");
        expr.getRight().visit(this);
        this.out.print(" )");
    }

    public void visit(ExprNodeFunction func) {
        Expr expr;
        this.out.print(func.getPrintName(this.context));
        this.out.print("(");
        int i = 1;
        while ((expr = func.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            expr.visit(this);
            ++i;
        }
        this.out.print(")");
    }

    public void visit(NodeValue nv) {
        this.out.print(nv.asQuotedString(this.context));
    }

    public void visit(NodeVar nv) {
        String s = nv.getVarName();
        if (nv.getVarName().startsWith(Constants.anonVarMarker)) {
            Node v = Node.createVariable((String)s);
            this.out.print(this.context.getBNodeMap().asString(v));
        } else {
            this.out.print("?");
            this.out.print(nv.getVarName());
        }
    }

    public void finishVisit() {
        this.out.flush();
    }
}

