/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FmtExprAbstract;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.Iterator;

public class FormatterPlain
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;

    public FormatterPlain(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterPlain fmt = new FormatterPlain(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext(null, null, null);
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterPlain.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public void visit(ElementTriplePattern el) {
        this.out.print("TriplePattern");
        this.out.print(" ");
        this.formatTriple(el.getTriple());
    }

    public void visit(ElementBlock el) {
        this.out.print("Block");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (el.getDataset() != null) {
            this.out.print("dataset");
        }
        el.getPatternElement().visit(this);
        this.out.decIndent(INDENT);
    }

    public void visit(ElementFilter el) {
        this.out.print("Constraint");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (el.getConstraint().isExpr()) {
            FmtExprAbstract v = new FmtExprAbstract(this.out, this.context);
            el.getConstraint().getExpr().visit(v);
        } else {
            this.out.print(el.getConstraint().toString());
        }
        this.out.decIndent(INDENT);
    }

    public void visit(ElementUnion el) {
        this.multiElement("Union", el.getElements().iterator());
    }

    public void visit(ElementGroup el) {
        this.multiElement("Group", el.getElements().iterator());
    }

    public void visit(ElementOptional el) {
        this.singleElement("Optional", el.getElement());
    }

    public void visit(ElementNamedGraph el) {
        this.singleElement("Graph", el.getElement());
    }

    public void visit(ElementUnsaid el) {
        this.singleElement("Unsaid", el.getElement());
    }

    public void visit(ElementExtension el) {
        Expr expr;
        this.out.print("Ext ");
        String uri = el.getURI();
        String tmp = FmtUtils.stringForURI(uri, this.context.getPrefixMapping());
        this.out.print(tmp);
        this.out.print("(");
        int i = 1;
        while ((expr = el.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            expr.visit(v);
            ++i;
        }
        this.out.print(")");
    }

    private void singleElement(String name, Element element) {
        this.out.print(name);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
    }

    private void multiElement(String name, Iterator iter) {
        this.out.print(name);
        this.out.incIndent(INDENT);
        while (iter.hasNext()) {
            this.out.newline();
            Element element = (Element)iter.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
    }

    public void visit(TemplateTriple template) {
        Triple t = template.getTriple();
        this.formatTriple(t);
    }

    public void visit(TemplateGroup tGroup) {
        this.out.print("Template Group");
        this.out.incIndent(INDENT);
        Iterator iter = tGroup.templates();
        while (iter.hasNext()) {
            this.out.newline();
            Template sub = (Template)iter.next();
            sub.visit(this);
        }
        this.out.decIndent(INDENT);
        this.out.println();
    }
}

