/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterExpr;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializer
implements QueryVisitor {
    static final int BLOCK_INDENT = 2;
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FormatterExpr fmtExpr;
    protected IndentedWriter out = null;

    QuerySerializer(OutputStream _out, FormatterElement formatterElement, FormatterExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this(new IndentedWriter(_out), formatterElement, formatterExpr, formatterTemplate);
    }

    QuerySerializer(IndentedWriter iwriter, FormatterElement formatterElement, FormatterExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this.out = iwriter;
        this.fmtTemplate = formatterTemplate;
        this.fmtElement = formatterElement;
        this.fmtExpr = formatterExpr;
    }

    public void startVisit(Query query2) {
    }

    public void visitResultForm(Query query2) {
    }

    public void visitBase(Query query2) {
        if (query2.getBaseURI() != null && query2.explicitlySetBaseURI()) {
            this.out.print("BASE    ");
            this.out.print("<" + query2.getBaseURI() + ">");
            this.out.newline();
        }
    }

    public void visitPrefixes(Query query2) {
        Map pmap = null;
        if (query2.getPrefixMapping() instanceof PrefixMapping2) {
            PrefixMapping2 pm2 = (PrefixMapping2)query2.getPrefixMapping();
            pmap = pm2.getNsPrefixMap(false);
        } else {
            pmap = query2.getPrefixMapping().getNsPrefixMap();
        }
        if (pmap.size() > 0) {
            Iterator iter = pmap.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                String v = (String)pmap.get(k);
                this.out.print("PREFIX  ");
                this.out.print(k);
                this.out.print(':');
                for (int i = 0; i < 5 - k.length(); ++i) {
                    this.out.print(' ');
                }
                this.out.print(" <" + v + ">");
                this.out.newline();
            }
        }
    }

    public void visitSelectResultForm(Query query2) {
        this.out.print("SELECT ");
        if (query2.isDistinct()) {
            this.out.print("DISTINCT ");
        }
        this.out.print(" ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query2, this.out, query2.getResultVars());
        }
        this.out.newline();
    }

    public void visitConstructResultForm(Query query2) {
        this.out.print("CONSTRUCT ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
            this.out.newline();
        } else {
            this.out.incIndent(2);
            this.out.newline();
            Template t = query2.getConstructTemplate();
            t.visit(this.fmtTemplate);
            this.out.decIndent(2);
        }
    }

    public void visitDescribeResultForm(Query query2) {
        this.out.print("DESCRIBE ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query2, this.out, query2.getResultVars());
            if (query2.getResultVars().size() > 0 && query2.getResultURIs().size() > 0) {
                this.out.print(" ");
            }
            QuerySerializer.appendURIList(query2, this.out, query2.getResultURIs());
        }
        this.out.newline();
    }

    public void visitAskResultForm(Query query2) {
        this.out.print("ASK");
        this.out.newline();
    }

    public void visitDatasetDecl(Query query2) {
        String uri;
        Iterator iter;
        if (query2.getGraphURIs() != null && query2.getGraphURIs().size() != 0) {
            this.out.print("FROM  ");
            iter = query2.getGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print(" ");
                this.out.print(FmtUtils.stringForURI(uri, query2.getPrefixMapping()));
            }
            this.out.newline();
        }
        if (query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() != 0) {
            iter = query2.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print("FROM NAMED ");
                this.out.print(FmtUtils.stringForURI(uri, query2.getPrefixMapping()));
                this.out.newline();
            }
        }
    }

    public void visitQueryPattern(Query query2) {
        if (query2.getQueryBlock() != null && query2.getQueryBlock().getPatternElement() != null) {
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            query2.getQueryBlock().visit(this.fmtElement);
            this.out.decIndent(2);
            this.out.newline();
        }
    }

    public void visitOrderBy(Query query2) {
        if (query2.hasOrderBy()) {
            this.out.print("ORDER BY ");
            boolean first = true;
            Iterator iter = query2.getOrderBy().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    this.out.print(" ");
                }
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                first = false;
            }
            this.out.println();
        }
    }

    public void visitLimit(Query query2) {
        if (query2.hasLimit()) {
            this.out.print("LIMIT   " + query2.getLimit());
            this.out.newline();
        }
    }

    public void visitOffset(Query query2) {
        if (query2.hasOffset()) {
            this.out.print("OFFSET  " + query2.getOffset());
            this.out.newline();
        }
    }

    public void finishVisit(Query query2) {
        this.out.flush();
    }

    static void appendVarList(Query query2, IndentedWriter sb, List vars) {
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (!first) {
                sb.print(" ");
            }
            sb.print("?");
            sb.print(var);
            first = false;
        }
    }

    static void appendURIList(Query query2, IndentedWriter sb, List vars) {
        SerializationContext cxt = new SerializationContext(query2);
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!first) {
                sb.print(" ");
            }
            sb.print(FmtUtils.stringForNode(node, cxt));
            first = false;
        }
    }
}

